/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.objectives.CorruptedObjective;

public class CorruptedCrystalObjective
extends CrystalObjective {
    protected IntRoll target;
    protected IntRoll secondTarget;
    protected float objectiveProbability;

    public CorruptedCrystalObjective(IntRoll target, IntRoll secondTarget, float objectiveProbability) {
        this.target = target;
        this.secondTarget = secondTarget;
        this.objectiveProbability = objectiveProbability;
    }

    public CorruptedCrystalObjective() {
    }

    public Optional<Integer> getColor(float v) {
        return Optional.of(0x1A1919);
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        MutableComponent cmp1 = ComponentUtils.corruptComponent((MutableComponent)new TextComponent("Objective: "));
        tooltip.add((Component)cmp1.m_7220_((Component)new TextComponent("Corrupted").m_130948_(Style.f_131099_.m_178520_(0x7A0000).m_178524_(Boolean.valueOf(true)))));
    }

    public void configure(Vault vault, RandomSource random) {
        int level = ((VaultLevel)vault.get(Vault.LEVEL)).get();
        Object object = ((Listeners)vault.get(Vault.LISTENERS)).get(Listeners.LOGIC);
        if (object instanceof ClassicListenersLogic) {
            ClassicListenersLogic classic = (ClassicListenersLogic)object;
            classic.set(ClassicListenersLogic.MIN_LEVEL, (Object)100);
        }
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(CorruptedObjective.of(this.target.get(random), this.secondTarget.get(random), this.objectiveProbability, ModConfigs.CORRUPTED_OBJECTIVE.getModifierPool(level)).add((Objective)AwardCrateObjective.ofConfig((VaultCrateBlock.Type)VaultCrateBlock.Type.valueOf((String)"CORRUPTED"), (String)"corrupted", (int)level, (boolean)true)).add((Objective)VictoryObjective.of((int)300)));
            objectives.add((Objective)BailObjective.create((boolean)true, (ResourceLocation[])new ResourceLocation[]{ClassicPortalLogic.EXIT}));
            objectives.add((Objective)DeathObjective.create((boolean)false));
            objectives.set(Objectives.KEY, (Object)CrystalData.OBJECTIVE.getType((ISerializable)this));
        });
    }

    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.INT_ROLL.writeNbt((ISerializable)this.target).ifPresent(target -> nbt.m_128365_("target", target));
        Adapters.INT_ROLL.writeNbt((ISerializable)this.secondTarget).ifPresent(target -> nbt.m_128365_("second_target", target));
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        return Optional.of(nbt);
    }

    public void readNbt(CompoundTag nbt) {
        this.target = (IntRoll)Adapters.INT_ROLL.readNbt((Tag)nbt.m_128469_("target")).orElse(IntRoll.ofConstant((int)30));
        this.secondTarget = (IntRoll)Adapters.INT_ROLL.readNbt((Tag)nbt.m_128469_("second_target")).orElse(IntRoll.ofConstant((int)25));
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.INT_ROLL.writeJson((ISerializable)this.target).ifPresent(target -> json.add("target", target));
        Adapters.INT_ROLL.writeJson((ISerializable)this.secondTarget).ifPresent(target -> json.add("second_target", target));
        Adapters.FLOAT.writeJson((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        return Optional.of(json);
    }

    public void readJson(JsonObject json) {
        this.target = (IntRoll)Adapters.INT_ROLL.readJson((JsonElement)json.getAsJsonObject("target")).orElse(IntRoll.ofConstant((int)30));
        this.secondTarget = (IntRoll)Adapters.INT_ROLL.readJson((JsonElement)json.getAsJsonObject("second_target")).orElse(IntRoll.ofConstant((int)35));
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

