/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.handler.SyncHandler;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.iwolfking.woldsvaults.api.util.CorruptedVaultClientHelper;
import xyz.iwolfking.woldsvaults.api.util.CorruptedVaultHelper;
import xyz.iwolfking.woldsvaults.client.sfx.LoopSoundHandler;
import xyz.iwolfking.woldsvaults.data.compound.FloatList;
import xyz.iwolfking.woldsvaults.events.vaultevents.client.WoldClientEvents;

public class CorruptedObjective
extends Objective {
    public static final SupplierKey<Objective> S_KEY = (SupplierKey)SupplierKey.of((String)"corrupted", Objective.class).with(Version.v1_31, CorruptedObjective::new);
    private static final ResourceLocation SHADER = new ResourceLocation("shaders/post/sobel.json");
    private static boolean queuedRefresh = true;
    private static boolean showedToggleShaderMessage = false;
    public static final FieldRegistry FIELDS = (FieldRegistry)Objective.FIELDS.merge((KeyRegistry)new FieldRegistry());
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of((String)"objective_probability", Float.class).with(Version.v1_2, (IBitAdapter)Adapters.FLOAT, (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);
    public static final FieldKey<CData> DATA = (FieldKey)FieldKey.of((String)"corrupted_vault_data", CData.class).with(Version.v1_31, (IBitAdapter)CompoundAdapter.of(CData::new), DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<FloatList> CORRUPTION_THRESHOLDS = (FieldKey)FieldKey.of((String)"corruption_thresholds", FloatList.class).with(Version.v1_31, (IBitAdapter)CompoundAdapter.of(FloatList::create), (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);
    public static final FieldKey<FloatList> ACTIVE_THRESHOLDS = (FieldKey)FieldKey.of((String)"active_thresholds", FloatList.class).with(Version.v1_31, (IBitAdapter)CompoundAdapter.of(FloatList::create), (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);

    public CorruptedObjective() {
    }

    public CorruptedObjective(int target, int secondaryTarget, float objectiveProbability, ResourceLocation randomModifierPool) {
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(DATA, (Object)new CData(target, secondaryTarget, randomModifierPool));
        this.set(CORRUPTION_THRESHOLDS, (Object)FloatList.create());
        this.set(ACTIVE_THRESHOLDS, (Object)FloatList.create());
    }

    public static CorruptedObjective of(int target, int secondaryTarget, float objectiveProbability, ResourceLocation randomModifierPool) {
        return new CorruptedObjective(target, secondaryTarget, objectiveProbability, randomModifierPool);
    }

    public SupplierKey<Objective> getKey() {
        return S_KEY;
    }

    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initClient(Vault vault) {
        WoldClientEvents.RENDER_TICK_EVENT.register(vault, renderTickEvent -> {
            Minecraft mc = Minecraft.m_91087_();
            GameRenderer render = mc.f_91063_;
            if (queuedRefresh || render.m_109149_() == null) {
                render.m_109128_(SHADER);
                queuedRefresh = false;
            }
        });
        ClientEvents.CLIENT_TICK.register((Object)vault, EventPriority.HIGH, data -> LoopSoundHandler.tick());
        CorruptedVaultHelper.isVaultCorrupted = true;
        if (Minecraft.m_91087_().f_91074_ != null && !showedToggleShaderMessage) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent("Shader may be toggled by pressing [F4]").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}), false);
            showedToggleShaderMessage = true;
        }
        super.initClient(vault);
    }

    public void initServer(VirtualWorld world, Vault vault) {
        CorruptedVaultHelper.setBaseVaultTimer(vault);
        CorruptedVaultHelper.preventFruits(this, vault);
        CorruptedVaultHelper.removeLocatorItem(this, vault);
        CorruptedVaultHelper.removeHealthReductionAttribute(this, vault);
        CorruptedVaultHelper.generateVaultModifierThresholds(this, world.m_5822_());
        CorruptedVaultHelper.generateRandomObelisks(this, world);
        CorruptedVaultHelper.generateObjectiveBlocks(this, world, vault);
        CorruptedVaultHelper.generateMonolithRoom(this, vault);
        CorruptedVaultHelper.handleObeliskUsage(this, world, vault);
        CorruptedVaultHelper.handleMonolithUsage(this, world, vault);
        CorruptedVaultHelper.handleKillTimeExtensions(this, world, vault);
        CorruptedVaultHelper.updateFracturedObeliskObfuscation(this);
        CorruptedVaultHelper.isVaultCorrupted = true;
        super.initServer(world, vault);
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        float corruptionMultiplier = CorruptedVaultHelper.setupVaultObjectiveValues(this, world, vault);
        CorruptedVaultHelper.tickDisplayOverlay(this, world, vault);
        CorruptedVaultHelper.tickCorruption(this, vault, corruptionMultiplier);
        if (world.m_46467_() % 20L == 0L) {
            CorruptedVaultHelper.checkCorruptionEvents(this, vault, world, ((Float)((CData)((Object)this.get(DATA))).get(CData.CORRUPTION)).floatValue());
        }
        if (((Boolean)((CData)((Object)this.get(DATA))).get(CData.INITIAL_COMPLETION)).booleanValue() && (Integer)((CData)((Object)this.get(DATA))).get(CData.TIME_TICKED_FAKE) <= 400) {
            CorruptedVaultHelper.tickFakeVictory(this);
        }
        if (((CData)((Object)this.get(DATA))).hasFullyCompleted()) {
            super.tickServer(world, vault);
        }
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority((Objective)this) < 0) {
            listener.addObjective(vault, (Objective)this);
        }
        if (((Boolean)((CData)((Object)this.get(DATA))).get(CData.INITIAL_COMPLETION)).booleanValue() && (Integer)((CData)((Object)this.get(DATA))).get(CData.TIME_TICKED_FAKE) <= 400) {
            CorruptedVaultHelper.fakeVictory(world, vault, listener, this);
        }
        listener.getPlayer().ifPresent(player -> {
            CorruptedVaultHelper.breakVaultPortal(world, vault, (Player)player);
            CorruptedVaultHelper.summonRoofSpikes(world, (Player)player, 64, 250, 0.45f);
            CorruptedVaultHelper.summonLightning(world, (Player)player, 64, 300, 0.6f);
            CorruptedVaultHelper.summonVoidSlashes(this, world, (Player)player, 96, 320, 0.5f);
            if ((Integer)((CData)((Object)((Object)this.get(DATA)))).get(CData.EVENT_CHECK) == 0 && ((Float)((CData)((Object)((Object)this.get(DATA)))).get(CData.CORRUPTION)).floatValue() > 10.0f && ((CData)((Object)((Object)this.get(DATA)))).hasCompletedInitial() && (Integer)((CData)((Object)((Object)this.get(DATA)))).get(CData.TIME_TICKED_FAKE) == 401) {
                CorruptedVaultHelper.summonWithers(world, player, 64, 3);
                ((CData)((Object)((Object)this.get(DATA)))).set(CData.EVENT_CHECK, 1);
            }
        });
        if (listener instanceof Runner && ((CData)((Object)this.get(DATA))).hasFullyCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack poseStack, Window window, float partialTicks, Player player) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int centerX = window.m_85445_() / 2;
        CorruptedVaultClientHelper.renderCorruptionOverlay(this, poseStack, font, window, centerX);
        CorruptedVaultClientHelper.renderTimeAddendOverlay(this, poseStack, window, player);
        if (CorruptedVaultHelper.shouldDisplayEscapePrompt(this)) {
            CorruptedVaultClientHelper.renderEscapePrompt(this, poseStack, font, centerX);
            return true;
        }
        CorruptedVaultClientHelper.renderObjectiveProgress(this, poseStack, font, centerX);
        return true;
    }

    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!((CData)((Object)this.get(DATA))).hasFullyCompleted()) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public static class CData
    extends DataObject<CData> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of((String)"count", Integer.class).with(Version.v1_0, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of((String)"target", Integer.class).with(Version.v1_0, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> BASE_TARGET = (FieldKey)FieldKey.of((String)"base_target", Integer.class).with(Version.v1_25, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> SECONDARY_COUNT = (FieldKey)FieldKey.of((String)"secondary_count", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> SECONDARY_TARGET = (FieldKey)FieldKey.of((String)"secondary_target", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> SECONDARY_BASE_TARGET = (FieldKey)FieldKey.of((String)"secondary_base_target", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<ResourceLocation> CORRUPTED_MODIFIER_POOL = (FieldKey)FieldKey.of((String)"corrupted_modifier_pool", ResourceLocation.class).with(Version.v1_31, (IBitAdapter)Adapters.IDENTIFIER, (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> DISPLAY_OVERLAY_TICK = (FieldKey)FieldKey.of((String)"display_overlay_tick", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_7, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> TIME_ADDEND_TICKS = (FieldKey)FieldKey.of((String)"time_addend_ticks", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_7, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Boolean> INITIAL_COMPLETION = (FieldKey)FieldKey.of((String)"initial_completion", Boolean.class).with(Version.v1_31, (IBitAdapter)Adapters.BOOLEAN, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Boolean> TRUE_COMPLETION = (FieldKey)FieldKey.of((String)"true_completion", Boolean.class).with(Version.v1_31, (IBitAdapter)Adapters.BOOLEAN, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> TIME_TICKED_FAKE = (FieldKey)FieldKey.of((String)"time_ticked_fake", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_7, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> SPAWNED_OBELISKS = (FieldKey)FieldKey.of((String)"spawned_obelisks", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_7, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Float> CORRUPTION = (FieldKey)FieldKey.of((String)"corruption", Float.class).with(Version.v1_31, (IBitAdapter)Adapters.FLOAT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
        public static final FieldKey<Integer> EVENT_CHECK = (FieldKey)FieldKey.of((String)"event_check", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_7, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);

        protected CData() {
        }

        protected CData(int target, int secondaryTarget, ResourceLocation stackModifierPool) {
            this.set(COUNT, 0);
            this.set(TARGET, target);
            this.set(BASE_TARGET, target);
            this.set(SECONDARY_COUNT, 0);
            this.set(SECONDARY_TARGET, secondaryTarget);
            this.set(SECONDARY_BASE_TARGET, secondaryTarget);
            this.set(CORRUPTED_MODIFIER_POOL, stackModifierPool);
            this.set(DISPLAY_OVERLAY_TICK, 0);
            this.set(TIME_ADDEND_TICKS, 0);
            this.set(INITIAL_COMPLETION, false);
            this.set(TRUE_COMPLETION, false);
            this.set(TIME_TICKED_FAKE, 0);
            this.set(SPAWNED_OBELISKS, 0);
            this.set(EVENT_CHECK, 0);
            this.set(CORRUPTION, Float.valueOf(0.0f));
        }

        public FieldRegistry getFields() {
            return FIELDS;
        }

        protected boolean hasFullyCompleted() {
            return this.hasCompletedInitial() && (Integer)this.get(SECONDARY_COUNT) >= (Integer)this.get(SECONDARY_TARGET) && (Boolean)this.get(TRUE_COMPLETION) != false;
        }

        public boolean hasCompletedInitial() {
            return (Integer)this.get(COUNT) >= (Integer)this.get(TARGET) && (Boolean)this.get(INITIAL_COMPLETION) != false;
        }
    }
}

