/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.ElixirObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.elixir.ElixirGoal;
import iskallia.vault.core.vault.objective.elixir.ElixirTask;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import xyz.iwolfking.woldsvaults.api.core.vault_events.VaultEvent;
import xyz.iwolfking.woldsvaults.api.util.NormalizedHelper;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.objectives.data.EnchantedEventsRegistry;

public class EnchantedElixirObjective
extends ElixirObjective {
    public static final SupplierKey<Objective> E_KEY = (SupplierKey)SupplierKey.of((String)"enchanted_elixir", Objective.class).with(Version.v1_12, EnchantedElixirObjective::new);
    private Map<ServerPlayer, Integer> elixirCollectionMap = new HashMap<ServerPlayer, Integer>();
    private Map<ServerPlayer, List<Float>> elixirBreakpointsMap = new HashMap<ServerPlayer, List<Float>>();
    private List<Listener> completedListeners = new ArrayList<Listener>();
    private boolean shouldCascadeRandomly = false;
    private boolean shouldCascade = true;
    private float cascadeIncrease = 0.0f;

    protected EnchantedElixirObjective() {
        this.set(GOALS, new ElixirObjective.GoalMap());
    }

    public static EnchantedElixirObjective create() {
        return new EnchantedElixirObjective();
    }

    public SupplierKey<Objective> getKey() {
        return E_KEY;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        NormalizedHelper.handleAddingNormalizedToVault(vault, (ServerLevel)world);
        super.initServer(world, vault);
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        ServerPlayer listenerPlayer;
        if (world == null || vault == null || listener == null) {
            return;
        }
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            if (listener.getPriority((Objective)this) < 0) {
                listener.addObjective(vault, (Objective)this);
                this.generateGoal(world, vault, runner);
                if (listener.getPlayer().isPresent()) {
                    this.elixirCollectionMap.put((ServerPlayer)listener.getPlayer().get(), 0);
                    this.generateElixirBreakpointsMap(listener, true);
                }
            }
        }
        if ((listenerPlayer = (ServerPlayer)listener.getPlayer().orElse(null)) == null) {
            return;
        }
        ElixirGoal goal = (ElixirGoal)((ElixirObjective.GoalMap)this.get(GOALS)).get(listener.get(Listener.ID));
        if (this.elixirBreakpointsMap != null && this.elixirBreakpointsMap.get(listener.getPlayer().get()) == null) {
            this.generateElixirBreakpointsMap(listener, false);
            Integer currentElixir = (Integer)goal.get(ElixirGoal.CURRENT);
            for (int i = 0; i < this.elixirBreakpointsMap.get(listenerPlayer).size() - 1; ++i) {
                if (!(this.elixirBreakpointsMap.get(listenerPlayer).get(i).floatValue() >= (float)currentElixir.intValue())) continue;
                if (i + 1 >= this.elixirBreakpointsMap.get(listenerPlayer).size()) {
                    this.completedListeners.add(listener);
                }
                this.elixirCollectionMap.put(listenerPlayer, i);
                break;
            }
        }
        if (!goal.isCompleted()) {
            ServerPlayer objPlayer = (ServerPlayer)listener.getPlayer().get();
            if ((float)((Integer)goal.get(ElixirGoal.CURRENT)).intValue() >= this.elixirBreakpointsMap.get(objPlayer).get(this.elixirCollectionMap.get(objPlayer)).floatValue()) {
                this.elixirCollectionMap.put(objPlayer, this.elixirCollectionMap.get(objPlayer) + 1);
                this.triggerRandomEvent(objPlayer, vault);
            }
        }
        if (goal.isCompleted() && !this.completedListeners.contains(listener)) {
            this.completedListeners.add(listener);
            this.triggerOmegaRandomEvent((ServerPlayer)listener.getPlayer().get(), vault);
        }
        if (goal.isCompleted()) {
            ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickListener(world, vault, listener));
        }
    }

    private void generateGoal(VirtualWorld world, Vault vault, Runner listener) {
        ElixirGoal goal = new ElixirGoal();
        ((ElixirObjective.GoalMap)this.get(GOALS)).put((Object)((UUID)listener.get(Listener.ID)), (Object)goal);
        JavaRandom random = JavaRandom.ofInternal((long)((Long)vault.get(Vault.SEED) ^ ((UUID)listener.get(Listener.ID)).getMostSignificantBits()));
        goal.set(ElixirGoal.TARGET, (Object)ModConfigs.ENCHANTED_ELIXIR.generateTarget(((VaultLevel)vault.get(Vault.LEVEL)).get(), (RandomSource)random));
        goal.set(ElixirGoal.BASE_TARGET, (Object)((Integer)goal.get(ElixirGoal.TARGET)));
        for (ElixirTask task : ModConfigs.ENCHANTED_ELIXIR.generateGoals(((VaultLevel)vault.get(Vault.LEVEL)).get(), (RandomSource)random)) {
            ((ElixirTask.List)goal.get(ElixirGoal.TASKS)).add((Object)task);
        }
        goal.initServer(world, vault, (ElixirObjective)this, listener.getId());
    }

    private void generateElixirBreakpointsMap(Listener listener, boolean sendMessage) {
        Random random = new Random();
        int numberOfBreakpoints = random.nextInt(10, 25);
        if (listener.getPlayer().isPresent()) {
            ElixirGoal goal = (ElixirGoal)((ElixirObjective.GoalMap)this.get(GOALS)).get(listener.get(Listener.ID));
            ArrayList<Float> elixirBreakPointsList = new ArrayList<Float>();
            Float elixirTarget = Float.valueOf(((Integer)goal.get(ElixirGoal.TARGET)).floatValue());
            for (int i = 0; i < numberOfBreakpoints; ++i) {
                float decimalModifier = ((float)i + 1.0f) / (float)numberOfBreakpoints;
                elixirBreakPointsList.add(Float.valueOf(elixirTarget.floatValue() * decimalModifier));
            }
            this.elixirBreakpointsMap.put((ServerPlayer)listener.getPlayer().get(), elixirBreakPointsList);
            if (!sendMessage) {
                return;
            }
            if (numberOfBreakpoints >= 10 && numberOfBreakpoints < 15) {
                listener.getPlayer().ifPresent(serverPlayer -> serverPlayer.m_5661_((Component)new TextComponent("You will experience a low number of random events this vault!").m_130940_(ChatFormatting.YELLOW), false));
            } else if (numberOfBreakpoints > 14 && numberOfBreakpoints < 19) {
                listener.getPlayer().ifPresent(serverPlayer -> serverPlayer.m_5661_((Component)new TextComponent("You will experience a moderate number of random events this vault!").m_130940_(ChatFormatting.AQUA), false));
            } else if (numberOfBreakpoints > 18 && numberOfBreakpoints < 25) {
                listener.getPlayer().ifPresent(serverPlayer -> serverPlayer.m_5661_((Component)new TextComponent("You will experience a high number of random events this vault!").m_130940_(ChatFormatting.LIGHT_PURPLE), false));
            }
        }
    }

    private void triggerRandomEvent(ServerPlayer objPlayer, Vault vault) {
        if (EnchantedEventsRegistry.getEvents().getRandom().isPresent()) {
            ((VaultEvent)EnchantedEventsRegistry.getEvents().getRandom().get()).triggerEvent(() -> ((ServerPlayer)objPlayer).m_20097_(), objPlayer, vault, true, VaultEvent.EventDisplayType.LEGACY);
        }
    }

    private void triggerOmegaRandomEvent(ServerPlayer objPlayer, Vault vault) {
        if (EnchantedEventsRegistry.getEvents().getRandom().isPresent()) {
            ((VaultEvent)EnchantedEventsRegistry.getOmegaEvents().getRandom().get()).triggerEvent(() -> ((ServerPlayer)objPlayer).m_20097_(), objPlayer, vault, true, VaultEvent.EventDisplayType.LEGACY);
        }
    }

    public void setShouldCascadeRandomly(boolean bool) {
        this.shouldCascadeRandomly = bool;
    }

    public void setShouldCascade(boolean bool) {
        this.shouldCascade = bool;
    }

    public void setCascadeIncrease(float value) {
        this.cascadeIncrease = value;
    }

    public float getCascadeIncrease() {
        return this.cascadeIncrease;
    }
}

