/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.FindExitObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.objectives.HauntedBraziersObjective;

public class HauntedBraziersCrystalObjective
extends CrystalObjective {
    protected IntRoll target;
    protected float objectiveProbability;

    public HauntedBraziersCrystalObjective() {
    }

    public HauntedBraziersCrystalObjective(IntRoll target, float objectiveProbability) {
        this.target = target;
        this.objectiveProbability = objectiveProbability;
    }

    public void configure(Vault vault, RandomSource random) {
        int level = ((VaultLevel)vault.get(Vault.LEVEL)).get();
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(HauntedBraziersObjective.of(this.target.get(random), this.objectiveProbability, ModConfigs.HAUNTED_BRAZIERS.getStackModifierPool(level), ModConfigs.HAUNTED_BRAZIERS.getOverStackModifierPool(level), ModConfigs.HAUNTED_BRAZIERS.getOverStackLootTable(level)).add(FindExitObjective.create((ResourceLocation[])new ResourceLocation[]{ClassicPortalLogic.EXIT}).add((Objective)AwardCrateObjective.ofConfig((VaultCrateBlock.Type)VaultCrateBlock.Type.MONOLITH, (String)"haunted_braziers", (int)level, (boolean)true))));
            objectives.add((Objective)BailObjective.create((boolean)true, (ResourceLocation[])new ResourceLocation[]{ClassicPortalLogic.EXIT}));
            objectives.add((Objective)DeathObjective.create((boolean)true));
            objectives.set(Objectives.KEY, (Object)CrystalData.OBJECTIVE.getType((ISerializable)this));
        });
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Light the Haunted Braziers").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }

    public Optional<Integer> getColor(float time) {
        return Optional.of(11452927);
    }

    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.INT_ROLL.writeNbt((ISerializable)this.target).ifPresent(target -> nbt.m_128365_("target", target));
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        return Optional.of(nbt);
    }

    public void readNbt(CompoundTag nbt) {
        this.target = (IntRoll)Adapters.INT_ROLL.readNbt((Tag)nbt.m_128469_("target")).orElse(IntRoll.ofUniform((int)3, (int)5));
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.INT_ROLL.writeJson((ISerializable)this.target).ifPresent(target -> json.add("target", target));
        Adapters.FLOAT.writeJson((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        return Optional.of(json);
    }

    public void readJson(JsonObject json) {
        this.target = (IntRoll)Adapters.INT_ROLL.readJson((JsonElement)json.getAsJsonObject("target")).orElse(IntRoll.ofUniform((int)3, (int)5));
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

