/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.MonolithBlock;
import iskallia.vault.block.entity.MonolithTileEntity;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.KillBossObjective;
import iskallia.vault.core.vault.objective.MonolithObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import iskallia.vault.network.message.MonolithIgniteMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import vazkii.quark.content.mobs.entity.Wraith;
import xyz.iwolfking.woldsvaults.api.util.NormalizedHelper;

public class HauntedBraziersObjective
extends MonolithObjective {
    public static final SupplierKey<Objective> E_KEY = (SupplierKey)SupplierKey.of((String)"haunted_braziers", Objective.class).with(Version.v1_12, HauntedBraziersObjective::new);
    public static final ResourceLocation HAUNTED_HUD = VaultMod.id((String)"textures/gui/monolith/haunted_hud.png");

    public HauntedBraziersObjective() {
    }

    public SupplierKey<Objective> getKey() {
        return E_KEY;
    }

    public HauntedBraziersObjective(int target, float objectiveProbability, ResourceLocation stackModifierPool, ResourceLocation overStackModifierPool, ResourceLocation lootTable) {
        this.set(COUNT, 0);
        this.set(TARGET, target);
        this.set(BASE_TARGET, target);
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(STACK_MODIFIER_POOL, stackModifierPool);
        this.set(OVER_STACK_MODIFIER_POOL, overStackModifierPool);
        this.set(OVER_STACK_LOOT_TABLE, lootTable);
    }

    public static HauntedBraziersObjective of(int target, float objectiveProbability, ResourceLocation stackModifierPool, ResourceLocation overStackModifierPool, ResourceLocation overStackLootTable) {
        return new HauntedBraziersObjective(target, objectiveProbability, stackModifierPool, overStackModifierPool, overStackLootTable);
    }

    public void initServer(VirtualWorld world, Vault vault) {
        NormalizedHelper.handleAddingNormalizedToVault(vault, (ServerLevel)world);
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of((Block)ModBlocks.MONOLITH).register((Object)this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
            } else {
                BlockPos pos = data.getPos();
                if (data.getState().m_61143_((Property)MonolithBlock.STATE) == MonolithBlock.State.EXTINGUISHED && ((Listeners)vault.get(Vault.LISTENERS)).getObjectivePriority(data.getPlayer().m_142081_(), (Objective)this) == 0) {
                    MonolithTileEntity tile;
                    BlockEntity patt8356$temp;
                    boolean overStacking;
                    boolean bl = overStacking = (Integer)this.get(COUNT) >= (Integer)this.get(TARGET);
                    if (overStacking) {
                        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)MonolithBlock.STATE, (Comparable)MonolithBlock.State.DESTROYED), 3);
                    } else {
                        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)MonolithBlock.STATE, (Comparable)MonolithBlock.State.LIT), 3);
                    }
                    this.playActivationEffects(world, pos, overStacking);
                    this.set(COUNT, (Integer)this.get(COUNT) + 1);
                    if (!overStacking) {
                        for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                            if (!(objective instanceof KillBossObjective)) continue;
                            KillBossObjective killBoss = (KillBossObjective)objective;
                            killBoss.set(KillBossObjective.BOSS_POS, (Object)pos);
                        }
                        List nearbyEntities = world.m_45976_(Wraith.class, Objects.requireNonNull(world.m_7702_(pos)).getRenderBoundingBox().m_82400_(64.0));
                        nearbyEntities.forEach(livingEntity -> {
                            livingEntity.m_7292_(new MobEffectInstance(ModEffects.NO_AI, 60, 0));
                            livingEntity.m_6469_(DamageSource.f_19319_, livingEntity.m_21233_() / 2.0f);
                        });
                    }
                    if (overStacking) {
                        LootTableKey table = (LootTableKey)VaultRegistry.LOOT_TABLE.getKey((ResourceLocation)this.get(OVER_STACK_LOOT_TABLE));
                        if (table == null) {
                            return;
                        }
                        LootTableGenerator generator = new LootTableGenerator((Version)vault.get(Vault.VERSION), table, 0.0f);
                        ChunkRandom randomx = ChunkRandom.any();
                        randomx.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), data.getPos(), 900397371L);
                        generator.generate((RandomSource)randomx);
                        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
                        generator.getItems().forEachRemaining(loot::add);
                        for (int i = 0; i < loot.size(); ++i) {
                            ItemStack stack2 = (ItemStack)loot.get(i);
                            VaultLevelItem.doInitializeVaultLoot((ItemStack)stack2, (Vault)vault, null);
                            stack2 = DataTransferItem.doConvertStack((ItemStack)stack2);
                            DataInitializationItem.doInitialize((ItemStack)stack2);
                            loot.set(i, stack2);
                        }
                        loot.removeIf(ItemStack::m_41619_);
                        loot.forEach(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
                        data.setResult(InteractionResult.SUCCESS);
                    }
                    if ((patt8356$temp = data.getWorld().m_7702_(pos)) instanceof MonolithTileEntity && !(tile = (MonolithTileEntity)patt8356$temp).getModifiers().isEmpty()) {
                        Iterator it = tile.getModifiers().entrySet().iterator();
                        TextComponent suffix = new TextComponent("");
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            VaultModifier modifier = VaultModifierRegistry.get((ResourceLocation)((ResourceLocation)entry.getKey()));
                            suffix.m_7220_(modifier.getChatDisplayNameComponent(((Integer)entry.getValue()).intValue()));
                            if (!it.hasNext()) continue;
                            suffix.m_7220_((Component)new TextComponent(", "));
                        }
                        TextComponent text = new TextComponent("");
                        if (!tile.getModifiers().isEmpty()) {
                            text.m_7220_(data.getPlayer().m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                        }
                        ChunkRandom random = ChunkRandom.any();
                        random.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), data.getPos(), 90039737L);
                        tile.getModifiers().forEach((modifierx, count) -> ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(VaultModifierRegistry.get((ResourceLocation)modifierx), count.intValue(), true, (RandomSource)random));
                        for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
                            listener.getPlayer().ifPresent(other -> {
                                world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                                other.m_5661_((Component)text, false);
                            });
                        }
                    }
                    data.setResult(InteractionResult.SUCCESS);
                }
            }
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.MONOLITH_UPDATE.register((Object)this, data -> {
            if (data.getWorld() == world && (!data.getEntity().isGenerated() || data.getEntity().isOverStacking() != (Integer)this.get(COUNT) >= (Integer)this.get(TARGET) && data.getState().m_61143_((Property)MonolithBlock.STATE) == MonolithBlock.State.EXTINGUISHED)) {
                ResourceLocation pool;
                data.getEntity().setOverStacking((Integer)this.get(COUNT) >= (Integer)this.get(TARGET));
                if (data.getEntity().isOverStacking()) {
                    data.getEntity().removeModifiers();
                }
                ResourceLocation resourceLocation = pool = data.getEntity().isOverStacking() ? (ResourceLocation)this.get(OVER_STACK_MODIFIER_POOL) : (ResourceLocation)this.get(STACK_MODIFIER_POOL);
                if (pool != null) {
                    int level = (Integer)((VaultLevel)vault.get(Vault.LEVEL)).getOr(VaultLevel.VALUE, (Object)0);
                    ChunkRandom random = ChunkRandom.any();
                    random.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), data.getPos(), 90039737L);
                    for (VaultModifier modifier : ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, level, (RandomSource)random)) {
                        data.getEntity().addModifier(modifier);
                    }
                }
                data.getEntity().setGenerated(true);
            }
        });
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initServer(world, vault));
    }

    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if ((Integer)this.get(COUNT) < (Integer)this.get(TARGET)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        double increase = CommonEvents.OBJECTIVE_TARGET.invoke(world, vault, 0.0).getIncrease();
        this.set(TARGET, (int)Math.round((double)((Integer)this.get(BASE_TARGET)).intValue() * (1.0 + increase)));
        if ((Integer)this.get(COUNT) >= (Integer)this.get(TARGET)) {
            ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickServer(world, vault));
        }
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos, boolean overStacking) {
        if (overStacking) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, world.m_8055_(pos));
            Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
            world.m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 400, 1.0, 1.0, 1.0, 0.5);
            world.m_8767_((ParticleOptions)ParticleTypes.f_175831_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 50, 1.0, 1.0, 1.0, 0.5);
            world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.DESTROY_MONOLITH, SoundSource.PLAYERS, 0.25f, 1.0f);
        } else {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithIgniteMessage(pos));
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if ((Integer)this.get(COUNT) >= (Integer)this.get(TARGET)) {
            int midX = window.m_85445_() / 2;
            Font font = Minecraft.m_91087_().f_91062_;
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            MutableComponent txt = new TextComponent("Grave Rob, or Exit to Complete").m_130940_(ChatFormatting.AQUA);
            font.m_92733_(txt.m_7532_(), (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
            return true;
        }
        int current = (Integer)this.get(COUNT);
        int total = (Integer)this.get(TARGET);
        MutableComponent txt = new TextComponent(String.valueOf(current)).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(String.valueOf(total)).m_130940_(ChatFormatting.WHITE));
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HAUNTED_HUD);
        float progress = (float)current / (float)total;
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)100);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)30.0f, (int)(13 + (int)(130.0f * progress)), (int)10, (int)200, (int)100);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        font.m_92733_(txt.m_7532_(), (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f, 31.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
        return true;
    }
}

