/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.google.gson.JsonObject;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import xyz.iwolfking.woldsvaults.objectives.UnhingedScavengerObjective;

public class UnhingedScavengerCrystalObjective
extends CrystalObjective {
    protected float objectiveProbability;

    public UnhingedScavengerCrystalObjective(float objectiveProbability) {
        this.objectiveProbability = objectiveProbability;
    }

    public UnhingedScavengerCrystalObjective() {
    }

    public void configure(Vault vault, RandomSource random) {
        int level = ((VaultLevel)vault.get(Vault.LEVEL)).get();
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(UnhingedScavengerObjective.of(this.objectiveProbability, UnhingedScavengerObjective.Config.DEFAULT).add((Objective)AwardCrateObjective.ofConfig((VaultCrateBlock.Type)VaultCrateBlock.Type.SCAVENGER, (String)"unhinged_scavenger", (int)level, (boolean)true)).add((Objective)VictoryObjective.of((int)300)));
            objectives.add((Objective)BailObjective.create((boolean)true, (ResourceLocation[])new ResourceLocation[]{ClassicPortalLogic.EXIT}));
            objectives.add((Objective)DeathObjective.create((boolean)true));
            objectives.set(Objectives.KEY, (Object)CrystalData.OBJECTIVE.getType((ISerializable)this));
        });
    }

    public void addText(List<Component> tooltip, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Unhinged Scavenger Hunt").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }

    public Optional<Integer> getColor(float time) {
        return Optional.of(3771264);
    }

    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        return Optional.of(nbt);
    }

    public void readNbt(CompoundTag nbt) {
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.FLOAT.writeJson((Number)Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        return Optional.of(json);
    }

    public void readJson(JsonObject json) {
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Unhinged Scavenger Hunt").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }
}

