/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import iskallia.vault.block.DivineAltarBlock;
import iskallia.vault.block.entity.ScavengerAltarTileEntity;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.handler.SyncHandler;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.item.GodBlessingItem;
import iskallia.vault.item.KeystoneItem;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.iwolfking.woldsvaults.api.util.NormalizedHelper;
import xyz.iwolfking.woldsvaults.config.UnhingedScavengerConfig;
import xyz.iwolfking.woldsvaults.init.ModConfigs;

public class UnhingedScavengerObjective
extends ScavengerObjective {
    public static final FieldKey<Config> CONFIG = (FieldKey)FieldKey.of((String)"config", Config.class).with(Version.v1_19, (IBitAdapter)Adapters.ofEnum(Config.class, (EnumAdapter.Mode)EnumAdapter.Mode.ORDINAL), (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);
    public static final SupplierKey<Objective> E_KEY = (SupplierKey)SupplierKey.of((String)"unhinged_scavenger", Objective.class).with(Version.v1_12, UnhingedScavengerObjective::new);

    public SupplierKey<Objective> getKey() {
        return E_KEY;
    }

    public UnhingedScavengerObjective(float objectiveProbability, Config config) {
        this.set(GOALS, new ScavengerObjective.GoalMap());
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(CONFIG, (Object)config);
    }

    public UnhingedScavengerObjective() {
        this.set(GOALS, new ScavengerObjective.GoalMap());
    }

    public static UnhingedScavengerObjective of(float objectiveProbability, Config config) {
        return new UnhingedScavengerObjective(objectiveProbability, config);
    }

    public void initServer(VirtualWorld world, Vault vault) {
        NormalizedHelper.handleAddingNormalizedToVault(vault, (ServerLevel)world);
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.SCAVENGER_ALTAR_CONSUME.register((Object)this, data -> {
            Listener listener;
            if (data.getLevel() == world && ((ScavengerAltarTileEntity)data.getTile()).getItemPlacedBy() != null && (listener = ((Listeners)vault.get(Vault.LISTENERS)).get(((ScavengerAltarTileEntity)data.getTile()).getItemPlacedBy())) instanceof Runner) {
                BlockState state = data.getTile().m_58900_();
                if (state.m_60734_() == ModBlocks.DIVINE_ALTAR) {
                    Item patt3532$temp = ((ScavengerAltarTileEntity)data.getTile()).getHeldItem().m_41720_();
                    if (patt3532$temp instanceof KeystoneItem) {
                        KeystoneItem keystone = (KeystoneItem)patt3532$temp;
                        if (keystone.getGod() != state.m_61143_((Property)DivineAltarBlock.GOD)) {
                            return;
                        }
                    } else {
                        if (!(((ScavengerAltarTileEntity)data.getTile()).getHeldItem().m_41720_() instanceof GodBlessingItem)) {
                            return;
                        }
                        if (GodBlessingItem.getGod((ItemStack)((ScavengerAltarTileEntity)data.getTile()).getHeldItem()) != state.m_61143_((Property)DivineAltarBlock.GOD)) {
                            return;
                        }
                    }
                }
                boolean creative = listener.getPlayer().map(ServerPlayer::m_7500_).orElse(false);
                CompoundTag nbt = ((ScavengerAltarTileEntity)data.getTile()).getHeldItem().m_41783_();
                if (creative || nbt != null && nbt.m_128461_("VaultId").equals(((UUID)vault.get(Vault.ID)).toString())) {
                    List goals = (List)((ScavengerObjective.GoalMap)this.get(GOALS)).get(listener.get(Listener.ID));
                    for (ScavengerGoal goal : goals) {
                        goal.consume(((ScavengerAltarTileEntity)data.getTile()).getHeldItem());
                    }
                }
            }
        });
        for (ScavengeTask task : ((Config)((Object)this.getOr(CONFIG, (Object)Config.DEFAULT))).get().getTasks()) {
            task.initServer(world, vault, (Objective)this);
        }
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initServer(world, vault));
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        ScavengerGoal.ObjList goal;
        if (listener instanceof Runner && listener.getPriority((Objective)this) < 0) {
            listener.addObjective(vault, (Objective)this);
            this.generateGoal(vault, listener);
        }
        if ((goal = (ScavengerGoal.ObjList)((ScavengerObjective.GoalMap)this.get(GOALS)).get(listener.get(Listener.ID))) != null && goal.areAllCompleted()) {
            ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickListener(world, vault, listener));
        }
    }

    private void generateGoal(Vault vault, Listener listener) {
        ScavengerGoal.ObjList list = new ScavengerGoal.ObjList();
        ((ScavengerObjective.GoalMap)this.get(GOALS)).put((Object)((UUID)listener.get(Listener.ID)), (Object)list);
        JavaRandom random = JavaRandom.ofInternal((long)((Long)vault.get(Vault.SEED) ^ ((UUID)listener.get(Listener.ID)).getMostSignificantBits()));
        list.addAll((Collection)((Config)((Object)this.getOr(CONFIG, (Object)Config.DEFAULT))).get().generateGoals(((VaultLevel)vault.get(Vault.LEVEL)).get(), (RandomSource)random));
    }

    public static enum Config {
        DEFAULT(() -> ModConfigs.UNHINGED_SCAVENGER),
        DIVINE_PARADOX(() -> iskallia.vault.init.ModConfigs.DIVINE_PARADOX);

        private Supplier<UnhingedScavengerConfig> supplier;

        private Config(Supplier supplier) {
            this.supplier = supplier;
        }

        public UnhingedScavengerConfig get() {
            return this.supplier.get();
        }
    }
}

