/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.handler.SyncHandler;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.iwolfking.vhapi.api.events.vault.VaultEvents;
import xyz.iwolfking.woldsvaults.WoldsVaults;

public class ZealotObjective
extends Objective {
    public static final ResourceLocation HUD = WoldsVaults.id("textures/gui/zealot/hud.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of((String)"zealot", Objective.class).with(Version.latest(), ZealotObjective::new);
    public static final FieldRegistry FIELDS = (FieldRegistry)Objective.FIELDS.merge((KeyRegistry)new FieldRegistry());
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of((String)"count", Integer.class).with(Version.v1_0, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of((String)"target", Integer.class).with(Version.v1_0, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<Integer> BASE_TARGET = (FieldKey)FieldKey.of((String)"base_target", Integer.class).with(Version.v1_25, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of((String)"objective_probability", Float.class).with(Version.v1_2, (IBitAdapter)Adapters.FLOAT, (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);

    protected ZealotObjective() {
    }

    protected ZealotObjective(int target, float objectiveProbability) {
        this.set(COUNT, 0);
        this.set(TARGET, target);
        this.set(BASE_TARGET, target);
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    public static ZealotObjective of(int target, float objectiveProbability) {
        return new ZealotObjective(target, objectiveProbability);
    }

    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        VaultEvents.GOD_ALTAR_COMPLETED.in((Level)world).register((Object)this, data -> this.set(COUNT, (Integer)this.get(COUNT) + 1));
        super.initServer(world, vault);
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        this.ifPresent(BASE_TARGET, value -> {
            double increase = CommonEvents.OBJECTIVE_TARGET.invoke(world, vault, 0.0).getIncrease();
            this.set(TARGET, (int)Math.round((double)((Integer)this.get(BASE_TARGET)).intValue() * (1.0 + increase)));
        });
        if ((Integer)this.get(COUNT) >= (Integer)this.get(TARGET)) {
            super.tickServer(world, vault);
        }
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority((Objective)this) < 0) {
            listener.addObjective(vault, (Objective)this);
        }
        if (listener instanceof Runner && (Integer)this.get(COUNT) >= (Integer)this.get(TARGET)) {
            super.tickListener(world, vault, listener);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if ((Integer)this.get(COUNT) >= (Integer)this.get(TARGET)) {
            int midX = window.m_85445_() / 2;
            Font font = Minecraft.m_91087_().f_91062_;
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            MutableComponent txt = new TextComponent("The gods are pleased, you may exit when ready.").m_130940_(ChatFormatting.GOLD);
            font.m_92733_(txt.m_7532_(), (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
            return true;
        }
        int current = (Integer)this.get(COUNT);
        int total = (Integer)this.get(TARGET);
        MutableComponent txt = new TextComponent(String.valueOf(current)).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(String.valueOf(total)).m_130940_(ChatFormatting.WHITE));
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        float progress = (float)current / (float)total;
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)100);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)30.0f, (int)(13 + (int)(130.0f * progress)), (int)10, (int)200, (int)100);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        font.m_92733_(txt.m_7532_(), (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f, 31.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
        return true;
    }

    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if ((Integer)this.get(COUNT) < (Integer)this.get(TARGET)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public SupplierKey<Objective> getKey() {
        return KEY;
    }
}

