/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives.data;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.init.ModEntities;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EntityType;

public class BrutalBossesRegistry {
    public static final WeightedList<EntityType<?>> BOSS_LIST = new WeightedList();
    public static final WeightedList<Component> BOSS_NAME_LIST = new WeightedList();
    public static final WeightedList<String> BOSS_MODS_LIST = new WeightedList();

    public static void init() {
        BrutalBossesRegistry.addBossNames();
        BrutalBossesRegistry.addBosses();
        BrutalBossesRegistry.addBossModifiers();
    }

    public static void addBosses() {
        BrutalBossesRegistry.register(ModEntities.AGGRESSIVE_COW_BOSS, (Double)10.0);
        BrutalBossesRegistry.register(ModEntities.BOOGIEMAN, (Double)10.0);
        BrutalBossesRegistry.register(ModEntities.BLUE_BLAZE, (Double)10.0);
        BrutalBossesRegistry.register(ModEntities.ROBOT, (Double)10.0);
        BrutalBossesRegistry.register(ModEntities.MONSTER_EYE, (Double)10.0);
        BrutalBossesRegistry.register(xyz.iwolfking.woldsvaults.init.ModEntities.WOLD, (Double)10.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_DROWNED, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_ZOMBIE, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_WITCH, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_HUSK, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_SKELETON, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_SPIDER, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_WITHER_SKELETON, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.ELITE_STRAY, (Double)20.0);
        BrutalBossesRegistry.register(ModEntities.VAULT_DOOD, (Double)20.0);
    }

    public static void addBossNames() {
        BrutalBossesRegistry.register((Component)new TextComponent("Ivan").m_130940_(ChatFormatting.RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Wold's Henchman").m_130940_(ChatFormatting.LIGHT_PURPLE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Steve Irwin").m_130940_(ChatFormatting.GREEN), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Joseph").m_130940_(ChatFormatting.GREEN), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Nausicaa").m_130940_(ChatFormatting.LIGHT_PURPLE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Player Hunter").m_130940_(ChatFormatting.RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Anime Hater").m_130940_(ChatFormatting.RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Steve").m_130940_(ChatFormatting.YELLOW), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Billy Joe").m_130940_(ChatFormatting.YELLOW), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Giraffe Hater").m_130940_(ChatFormatting.YELLOW), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Vault Filters Hater").m_130940_(ChatFormatting.DARK_RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Karen").m_130940_(ChatFormatting.AQUA), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Arnold").m_130940_(ChatFormatting.WHITE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("The Beast").m_130940_(ChatFormatting.GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Slayer").m_130940_(ChatFormatting.GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Brutalizer").m_130940_(ChatFormatting.GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Wold's Elite").m_130940_(ChatFormatting.GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Wold's Mercenary").m_130940_(ChatFormatting.GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Skill Issue").m_130940_(ChatFormatting.GREEN), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Murderous Intentions").m_130940_(ChatFormatting.RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Powerful Entity").m_130940_(ChatFormatting.DARK_PURPLE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("The Rock").m_130940_(ChatFormatting.BLACK), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Spire Slayer").m_130940_(ChatFormatting.GOLD), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Meance").m_130940_(ChatFormatting.BLUE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Wold's Chunker").m_130940_(ChatFormatting.BLUE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Chonker").m_130940_(ChatFormatting.BLUE), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Big Boy").m_130940_(ChatFormatting.AQUA), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Big Bertha").m_130940_(ChatFormatting.AQUA), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Large Searge").m_130940_(ChatFormatting.DARK_GREEN), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("King").m_130940_(ChatFormatting.GOLD), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Ohmwrecker").m_130940_(ChatFormatting.GOLD), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Rager").m_130940_(ChatFormatting.RED), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Elite").m_130940_(ChatFormatting.DARK_GRAY), (Double)2.0);
        BrutalBossesRegistry.register((Component)new TextComponent("Professional Vault Hunter Slayer").m_130940_(ChatFormatting.DARK_GRAY), (Double)2.0);
    }

    public static void addBossModifiers() {
        BrutalBossesRegistry.register("Bulwark", (Double)10.0);
        BrutalBossesRegistry.register("1UP", (Double)10.0);
        BrutalBossesRegistry.register("Alchemist", (Double)10.0);
        BrutalBossesRegistry.register("Berserk", (Double)10.0);
        BrutalBossesRegistry.register("Blastoff", (Double)10.0);
        BrutalBossesRegistry.register("Choke", (Double)10.0);
        BrutalBossesRegistry.register("Cloaking", (Double)10.0);
        BrutalBossesRegistry.register("Darkness", (Double)10.0);
        BrutalBossesRegistry.register("Exhaust", (Double)10.0);
        BrutalBossesRegistry.register("Fiery", (Double)10.0);
        BrutalBossesRegistry.register("Ghastly", (Double)10.0);
        BrutalBossesRegistry.register("Gravity", (Double)10.0);
        BrutalBossesRegistry.register("Poisonous", (Double)10.0);
        BrutalBossesRegistry.register("Quicksand", (Double)10.0);
        BrutalBossesRegistry.register("Regen", (Double)10.0);
        BrutalBossesRegistry.register("Sapper", (Double)10.0);
        BrutalBossesRegistry.register("Sprint", (Double)10.0);
        BrutalBossesRegistry.register("Storm", (Double)10.0);
        BrutalBossesRegistry.register("Vengeance", (Double)10.0);
        BrutalBossesRegistry.register("Weakness", (Double)10.0);
        BrutalBossesRegistry.register("Webber", (Double)10.0);
        BrutalBossesRegistry.register("Wither", (Double)10.0);
    }

    public static void register(EntityType<?> bossEntity, Double weight) {
        BOSS_LIST.add(bossEntity, weight);
    }

    public static void register(Component bossName, Double weight) {
        BOSS_NAME_LIST.add((Object)bossName, weight);
    }

    public static void register(String modifierString, Double weight) {
        BOSS_MODS_LIST.add((Object)modifierString, weight);
    }

    public static String getRandomMobModifiers() {
        return BrutalBossesRegistry.getRandomMobModifiers(6, true);
    }

    public static String getRandomMobModifiers(int count, boolean randomlyFail) {
        StringBuilder modifierList = new StringBuilder();
        Random random = new Random();
        int failCount = 0;
        int maxFails = 4;
        for (int i = 0; i < count; ++i) {
            if (randomlyFail && random.nextBoolean() && failCount < maxFails) {
                ++failCount;
                continue;
            }
            modifierList.append((String)BOSS_MODS_LIST.getRandom().get()).append(" ");
        }
        if (modifierList.isEmpty()) {
            modifierList.append("Bulwark");
        }
        return modifierList.toString().trim();
    }
}

