/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives.data;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import iskallia.vault.VaultMod;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.LoadingModList;
import samebutdifferent.ecologics.registry.ModMobEffects;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.api.core.vault_events.VaultEvent;
import xyz.iwolfking.woldsvaults.api.core.vault_events.VaultEventSystem;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.DelayTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.ExecuteEventsTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.ItemRewardTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.MessageTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.MobMobEffectTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.PlaySoundTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.PlayerMobEffectTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.PlayerSwapTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.RepeatTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.SpawnMobTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.TaskGroup;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.VaultModifierFromPoolTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.VaultModifierTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks.WeightedTask;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.EventTag;
import xyz.iwolfking.woldsvaults.api.util.ref.Effect;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.objectives.data.builtin.events.CloudStorageEvents;
import xyz.iwolfking.woldsvaults.objectives.data.builtin.events.ThermalEvents;
import xyz.iwolfking.woldsvaults.objectives.data.builtin.events.WildBackportEvents;

public class EnchantedEventsRegistry {
    private static final WeightedList<VaultEvent> ENCHANTED_EVENTS = new WeightedList();
    private static final WeightedList<VaultEvent> OMEGA_ENCHANTED_EVENTS = new WeightedList();
    private static final WeightedList<VaultEvent> POSITIVE_ENCHANTED_EVENTS = new WeightedList();
    private static final WeightedList<VaultEvent> NEGATIVE_ENCHANTED_EVENTS = new WeightedList();
    private static final WeightedList<VaultEvent> SPAWN_ENTITY_ENCHANTED_EVENTS = new WeightedList();
    private static final WeightedList<VaultEvent> MODIFIER_ENCHANTED_EVENTS = new WeightedList();

    public static void register(ResourceLocation id, VaultEvent event, Double weight) {
        VaultEventSystem.register(id, event);
        ENCHANTED_EVENTS.add((Object)event, weight);
        if (event.getEventTags().contains((Object)EventTag.OMEGA)) {
            OMEGA_ENCHANTED_EVENTS.add((Object)event, weight);
        }
        if (event.getEventTags().contains((Object)EventTag.POSITIVE)) {
            POSITIVE_ENCHANTED_EVENTS.add((Object)event, weight);
        }
        if (event.getEventTags().contains((Object)EventTag.NEGATIVE)) {
            NEGATIVE_ENCHANTED_EVENTS.add((Object)event, weight);
        }
        if (event.getEventTags().contains((Object)EventTag.SPAWN_MOB)) {
            SPAWN_ENTITY_ENCHANTED_EVENTS.add((Object)event, weight);
        }
        if (event.getEventTags().contains((Object)EventTag.ADDS_MODIFIER)) {
            MODIFIER_ENCHANTED_EVENTS.add((Object)event, weight);
        }
    }

    public static WeightedList<VaultEvent> getEvents() {
        return ENCHANTED_EVENTS;
    }

    public static WeightedList<VaultEvent> getOmegaEvents() {
        return OMEGA_ENCHANTED_EVENTS;
    }

    public static void registerAllBuiltInEvents() {
        EnchantedEventsRegistry.register(WoldsVaults.id("common_positive_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#cccc00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"basic_positive"))).build("Common Positive Modifier", new TextComponent("Adds a modifier from a common pool of positive modifiers.")), 60.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("rare_positive_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#8cff1a")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"medium_positive"))).build("Rare Positive Modifier", new TextComponent("Adds a modifier from a rare pool of positive modifiers.")), 35.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("omega_positive_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#77ff33")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"omega_positive"))).build("Omegas Positive Modifier", new TextComponent("Adds a modifier from an omega pool of positive modifiers.")), 6.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("gods_blessing_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#ff80d5")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"gods_omega_blessing"))).build("God's Blessing", new TextComponent("The God's bless your with one of their omega favour modifiers.")), 3.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("common_negative_modifier"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#ff1a1a")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"basic_negative"))).build("Common Negative Modifier", new TextComponent("Adds a modifier from a common pool of negative modifiers.")), 60.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("rare_negative_modifier"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#660000")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"medium_negative"))).build("Rare Negative Modifier", new TextComponent("Adds a modifier from a rare pool of negative modifiers.")), 35.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("omega_negative_modifier"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#330000")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"omega_negative"))).build("Rare Positive Modifier", new TextComponent("Adds a modifier from an omega pool of negative modifiers.")), 6.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("mob_onhits_modifier"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#00a3cc")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"mob_onhits"))).build("Mob On-Hits Modifier", new TextComponent("Adds a nasty modifier that adds on-hit effects to mobs.")), 6.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("chaos_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#4d4dff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"chaos_enchanted"))).build("Chaos Modifier", new TextComponent("Adds 5-10 random modifiers from the Chaos modifier pool.")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("curses_modifier"), new VaultEvent.Builder().tag(EventTag.OMEGA).tag(EventTag.NEGATIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#3d0099")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"curses"))).build("Curses!", new TextComponent("Adds a random modifier from the Curses modifier pool.")), 1.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("cascading_chests_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#d5ff80")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"enchanted_cascade"))).build("Cascading Chests", new TextComponent("Adds a random modifier from the Cascading Chests modifier pool.")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("i_can_see_forever"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#8585ad")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"hunters_enchanted"))).build("I Can See Forever", new TextComponent("Adds all Hunters modifiers.")), 1.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("random_hunter_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#8585ad")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"hunters_enchanted_random"))).build("Hunter Modifier", new TextComponent("Adds a random Hunter modifier.")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("bingo_modifier"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#4d4dff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierFromPoolTask(VaultMod.id((String)"bingos_enchanted"))).build("Bingo!?", new TextComponent("Adds a random Bingo modifier.")), 3.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("slippery_floors"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#adebeb")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect((MobEffect)ModMobEffects.SLIPPERY.get(), 10, 1800).build()).build("Slippery Floors", new TextComponent("Who forgot to dry the floor!? Makes movement slippery.")), 16.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("curse_of_the_sunbird"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#804000")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(AMEffectRegistry.SUNBIRD_CURSE, 0, 1800).build()).build("Curse of the Sunbird", new TextComponent("It seems gravity is higher...")), 9.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("blessing_of_the_sunbird"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#ff9900")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(AMEffectRegistry.SUNBIRD_BLESSING, 0, 1800).build()).build("Blessing of the Sunbird", new TextComponent("Glide to safety on feathered wing.")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("clinging_effect"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#bfff00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(AMEffectRegistry.CLINGING, 0, 1200).build()).build("Topsy Turvy", new TextComponent("Walk on ceilings o.o")), 3.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("levitation"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#b300b3")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19620_, 0, 400).build()).build("Leviosa", new TextComponent("Up up and away")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("insta_kill"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#ff8c1a")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19600_, 255, 600).effect(xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER, 255, 600).build()).build("Insta-Kill", new TextComponent("Grants Max Strength + Empower")), 14.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("hyper_speed"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#e6e600")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING, 9, 900).effect(MobEffects.f_19598_, 9, 900).build()).build("Hyperspeed", new TextComponent("Grants big speed boost!")), 14.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("bolstered"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#804000")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19606_, 2, 900).effect(MobEffects.f_19607_, 4, 900).effect(AMEffectRegistry.POISON_RESISTANCE, 9, 900).build()).build("Bolstered", new TextComponent("Grants Damage resistance, fire resistance, and poison resistance.")), 16.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("chemical_bath"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#333300")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19615_, 1, 300).effect(MobEffects.f_19614_, 1, 300).effect(ModEffects.BLEED, 1, 300).effect(ModEffects.VULNERABLE, 0, 900).effect(MobEffects.f_19610_, 0, 600).effect(MobEffects.f_19612_, 2, 400).effect(MobEffects.f_19619_, 0, 300).effect(MobEffects.f_19613_, 2, 600).effect(MobEffects.f_19604_, 0, 360).effect(MobEffects.f_19605_, 1, 360).effect(MobEffects.f_19617_, 1, 300).effect(AMEffectRegistry.BUG_PHEROMONES, 1, 600).build()).build("Chemical Bath", new TextComponent("A nasty brew of potion effects.")), 5.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("holy_blessing"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#ffd966")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19606_, 3, 400).effect(MobEffects.f_19607_, 4, 400).effect(MobEffects.f_19608_, 4, 400).effect(xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING, 5, 400).effect(xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER, 5, 400).effect(MobEffects.f_19598_, 4, 400).effect(MobEffects.f_19618_, 3, 400).effect(MobEffects.f_19619_, 0, 400).effect(MobEffects.f_19605_, 2, 400).effect(MobEffects.f_19617_, 2, 400).effect(MobEffects.f_19611_, 0, 400).build()).build("Holy Concoction", new TextComponent("A beautiful brew of potion effects.")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("barnyard_bash"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#666633")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity(ModEntities.AGGRESSIVE_COW, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.HOSTILE_CHICKEN, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.HOSTILE_SHEEP, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.HOSTILE_PIG, 3.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 1, 300), 1.0).build()).build("Barnyard Bash", new TextComponent("Attack of the farm animals!")), 9.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("creeper_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#1aff66")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity(ModEntities.T1_CREEPER, 9.0).entity(ModEntities.T2_CREEPER, 6.0).entity(ModEntities.T3_CREEPER, 3.0).amount(5, 15.0).amount(7, 10.0).amount(9, 8.0).effect(new Effect(MobEffects.f_19606_, 1, 300), 1.0).build()).build("Jeepers Creepers!", new TextComponent("Attack of the creepers!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("zombie_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#006600")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity(ModEntities.T1_ZOMBIE, 9.0).entity(ModEntities.T2_ZOMBIE, 6.0).entity(ModEntities.T3_ZOMBIE, 3.0).amount(5, 15.0).amount(7, 10.0).amount(9, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Project Zomboid", new TextComponent("Attack of the zombies!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("bunfungus_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#ffb3b3")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)AMEntityRegistry.BUNFUNGUS.get(), 9.0).entity((EntityType)AMEntityRegistry.MUNGUS.get(), 3.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Bunfungus Amongus", new TextComponent("I am Joseph and I like bunnies")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("spider_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#0d0033")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity(ModEntities.VAULT_SPIDER, 9.0).entity(ModEntities.VAULT_SPIDER_BABY, 3.0).entity(ModEntities.DUNGEON_SPIDER, 5.0).entity(ModEntities.DUNGEON_BLACK_WIDOW_SPIDER, 1.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Arachno-no-no", new TextComponent("They are crawling everywhere! NO NO NO!!!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("ghost_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#ff471a")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity(ModEntities.VAULT_WRAITH_WHITE, 8.0).entity(ModEntities.VAULT_WRAITH_YELLOW, 2.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.BLUE_GHOST, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.RED_GHOST, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.GREEN_GHOST, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.BROWN_GHOST, 1.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.BLACK_GHOST, 1.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.PURPLE_GHOST, 1.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Happy Halloween", new TextComponent("Poltergeists appear to pummel you.")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("turtle_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#40bf40")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)AMEntityRegistry.ALLIGATOR_SNAPPING_TURTLE.get(), 1.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Ninja Turtles", new TextComponent("Turtles come to trounce you.")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("zoo_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#85e085")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)AMEntityRegistry.ALLIGATOR_SNAPPING_TURTLE.get(), 1.0).entity((EntityType)AMEntityRegistry.CROCODILE.get(), 3.0).entity((EntityType)AMEntityRegistry.TIGER.get(), 6.0).entity((EntityType)AMEntityRegistry.KOMODO_DRAGON.get(), 4.0).entity((EntityType)AMEntityRegistry.ELEPHANT.get(), 1.0).entity((EntityType)AMEntityRegistry.SNOW_LEOPARD.get(), 4.0).spawnRanges(13.0, 23.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Escaped Zoo", new TextComponent("Who's Alex anyway?")), 5.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("void_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#bf00ff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)AMEntityRegistry.ENDERIOPHAGE.get(), 9.0).entity((EntityType)AMEntityRegistry.COSMIC_COD.get(), 1.0).entity((EntityType)AMEntityRegistry.MIMICUBE.get(), 3.0).entity(ModEntities.T2_ENDERMAN, 6.0).spawnRanges(13.0, 23.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Void Invasion", new TextComponent("No really, WHO IS ALEX!?")), 3.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("dweller_attack"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#ff6666")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)ModEntities.VAULT_FIGHTER_TYPES.get(1), 15.0).entity((EntityType)ModEntities.VAULT_FIGHTER_TYPES.get(2), 9.0).entity((EntityType)ModEntities.VAULT_FIGHTER_TYPES.get(3), 6.0).entity((EntityType)ModEntities.VAULT_FIGHTER_TYPES.get(4), 3.0).amount(4, 15.0).amount(6, 10.0).amount(8, 8.0).effect(new Effect(MobEffects.f_19606_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19600_, 2, 400), 1.0).effect(new Effect(MobEffects.f_19596_, 2, 400), 1.0).build()).build("Dweller Duel", new TextComponent("Attack of the Vault Dwellers")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("box_giveaway"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#4d94ff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ItemRewardTask.Builder().item((Item)ModItems.SUPPLY_BOX, 4, 5.0).item((Item)ModItems.AUGMENT_BOX, 1, 5.0).item((Item)ModItems.CATALYST_BOX, 1, 3.0).item((Item)ModItems.GEM_BOX, 4, 5.0).item((Item)ModItems.OMEGA_BOX, 1, 1.0).item((Item)iskallia.vault.init.ModItems.MOD_BOX, 1, 5.0).item((Item)iskallia.vault.init.ModItems.MYSTERY_BOX, 8, 5.0).build()).build("Wolf's Box Giveaway", new TextComponent("Never tell me I don't do anything for you.")), 5.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("sweet_eats"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#7979d2")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ItemRewardTask.Builder().item((Item)ModItems.VAULT_ROCK_CANDY, 8, 5.0).build()).build("Wolf's Sweet Surprise", new TextComponent("Enjoy your delicious rock-hard candy!")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("pandamonium"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#4dffff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ExecuteEventsTask(() -> SPAWN_ENTITY_ENCHANTED_EVENTS, 5)).build("PANDAMONIUM!", new TextComponent("Unleash the Horde!")), 1.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("horde_night"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#5c5cd6")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ExecuteEventsTask(() -> SPAWN_ENTITY_ENCHANTED_EVENTS, 3)).build("Horde Night", new TextComponent("Unleash the Horde!")), 5.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("five_random_events"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.POSITIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#66b3ff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ExecuteEventsTask(() -> ENCHANTED_EVENTS, 5)).build("5 Random Events", new TextComponent("Let's see what you get...")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("three_random_omega"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.POSITIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#66b3ff")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ExecuteEventsTask(() -> OMEGA_ENCHANTED_EVENTS, 3)).build("3 Random Omega Events", new TextComponent("3 random Omega events... did you get lucky?")), 1.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("three_random_modifier"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#ff66b3")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new ExecuteEventsTask(() -> MODIFIER_ENCHANTED_EVENTS, 3)).build("3 Random Modifier Events", new TextComponent("3 random Modifier events... did you get lucky?")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("vampire_survivors"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#ffc34d")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierTask(VaultMod.id((String)"leeching"), 1, 2400)).task(new SpawnMobTask.Builder().entity(EntityType.f_20549_, 1.0).spawnRanges(13.0, 25.0).amount(8, 1.0).build()).build("Vampire Survivors", new TextComponent("Grants leeching for a period and spawns bats!")), 2.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("teleswap"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#cc6699")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerSwapTask()).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19604_, 0, 120).build()).build("Teleswap", new TextComponent("Swaps you and another player's location!")), 10.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("mob_vigor"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19600_, 3, 3600).effect(MobEffects.f_19596_, 3, 3600).grantAll().build()).build("Mob Invigoration", new TextComponent("Gives nearby mobs a damage and speed boost!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("mob_downgrade"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19613_, 5, 1200).effect(MobEffects.f_19597_, 5, 3600).grantAll().build()).build("Mob Downgrade", new TextComponent("Gives nearby mobs a damage and speed downgrade!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("mob_invisibility"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19609_, 0, 3600).grantAll().build()).build("Mob Invisibility", new TextComponent("Makes nearby mobs disappear!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("mob_resistance"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19606_, 3, 3600).effect(AMEffectRegistry.POISON_RESISTANCE, 3, 3600).grantAll().build()).build("Mob Resistance", new TextComponent("Nearby mobs get a heap of damage resistance!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("random_mob_buffs"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19606_, 1, 3600).effect(AMEffectRegistry.POISON_RESISTANCE, 1, 3600).effect(AMEffectRegistry.SOULSTEAL, 1, 3600).effect(MobEffects.f_19596_, 4, 3600).effect(MobEffects.f_19600_, 4, 3600).effect(MobEffects.f_19605_, 4, 3600).amount(3).grantAll().build()).build("Mob Resistance", new TextComponent("Nearby mobs get random buffs!")), 12.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("minimize_mobs"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.SHRINKING, 3, 3600).grantAll().build()).build("Mob Minimizer", new TextComponent("Nearby mobs get teeny weeny!")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("maximize_mobs"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#789D00")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new MobMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.GROWING, 1, 3600).grantAll().build()).build("Mob Maximizer", new TextComponent("Nearby mobs get a growth spurt!")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("shrink_ray"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#ff8c1a")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.SHRINKING, 1, 600).build()).build("Shrink Ray", new TextComponent("Honey I shrunk the vaulters!")), 3.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("purifying_aura"), new VaultEvent.Builder().tag(EventTag.POSITIVE).color(TextColor.m_131268_((String)"#7D9BFF")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(ModEffects.PURIFYING_AURA, 0, 1200).build()).build("Purifying Aura", new TextComponent("Become immune to negative effects for a while.")), 8.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("turkey_feast"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).tag(EventTag.SPAWN_MOB).color(TextColor.m_131268_((String)"#8871744")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19618_, 3, 2400).effect(MobEffects.f_19605_, 1, 1200).build()).task(new PlaySoundTask(SoundEvents.f_11912_)).task(new SpawnMobTask.Builder().entity(xyz.iwolfking.woldsvaults.init.ModEntities.HATURKIN, 3.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.HOSTILE_TURKEY, 6.0).entity(xyz.iwolfking.woldsvaults.init.ModEntities.HOSTILE_CHICKEN, 4.0).effect(new Effect(MobEffects.f_19605_, 9, 1200), 1.0).effect(new Effect(MobEffects.f_19606_, 1, 1200), 1.0).effect(new Effect(MobEffects.f_19596_, 1, 1200), 1.0).build()).build("Fowl Feast", new TextComponent("Spawns some angry fowls and grants big saturation and regeneration for a while!")), 4.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("soul_fest"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#87008E")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierTask(VaultMod.id((String)"soul_fest"), 1, 1200)).build("Soul Fest", new TextComponent("Big soul shard boost for a limited time!")), 2.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("surprise_boxes"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#884569")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierTask(VaultMod.id((String)"surprise_boxes"), 1, 1600)).task(new VaultModifierTask(VaultMod.id((String)"hoard"), 1, 1600)).task(new VaultModifierTask(VaultMod.id((String)"fortuitous"), 1, 1600)).build("Surprise!?", new TextComponent("Chests spawn nasty mobs and other things but have more stuffs for a limited time!")), 4.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("no_fruit_or_temporal"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#676934")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierTask(VaultMod.id((String)"rotten"), 1, 6000)).task(new VaultModifierTask(VaultMod.id((String)"no_temporal_shard"), 1, 6000)).build("Rotten Core", new TextComponent("Fruit, Temporal Shards, and Companions are temporarily disabled!")), 4.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("lunar"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.OMEGA).tag(EventTag.ADDS_MODIFIER).color(TextColor.m_131268_((String)"#676934")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new VaultModifierTask(VaultMod.id((String)"jumpy_deluxe"), 3, 2400)).task(new VaultModifierTask(VaultMod.id((String)"lunar"), 1, 2400)).build("Lunar Gravity", new TextComponent("Huge jump boost and mobs float for a limited time!")), 4.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("strange_times"), new VaultEvent.Builder().tag(EventTag.NEGATIVE).color(TextColor.m_131268_((String)"#843E34")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new RepeatTask(new WeightedTask.Builder().task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19620_, 0, 120).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19604_, 0, 240).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19610_, 0, 120).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19612_, 2, 240).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19611_, 0, 120).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19615_, 0, 120).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING, 2, 240).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER, 2, 240).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(MobEffects.f_19606_, 2, 240).build(), 1.0).task(new PlayerMobEffectTask.Builder().effect(AMEffectRegistry.SOULSTEAL, 0, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER, 2, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19620_, 0, 120).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19604_, 0, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19610_, 0, 120).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19612_, 2, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19611_, 0, 120).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19615_, 0, 120).build(), 1.0).task(new MobMobEffectTask.Builder().effect(xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING, 2, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19606_, 2, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19600_, 4, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(MobEffects.f_19596_, 3, 240).build(), 1.0).task(new MobMobEffectTask.Builder().effect(AMEffectRegistry.SOULSTEAL, 0, 240).build(), 1.0).build(), 120, 60)).build("Strange Times", new TextComponent("Strange effects happen to you and mobs around you!")), 6.0);
        EnchantedEventsRegistry.register(WoldsVaults.id("la_cucaracha"), new VaultEvent.Builder().tag(EventTag.POSITIVE).tag(EventTag.NEGATIVE).tag(EventTag.OMEGA).color(TextColor.m_131268_((String)"#ff6666")).displayType(VaultEvent.EventDisplayType.LEGACY).task(new SpawnMobTask.Builder().entity((EntityType)AMEntityRegistry.COCKROACH.get(), 1.0).amount(4, 1.0).heldStack(new ItemStack((ItemLike)AMItemRegistry.MARACA.get())).build()).task(new PlaySoundTask(AMSoundRegistry.LA_CUCARACHA)).task(new DelayTask(100)).task(new WeightedTask.Builder().task(new TaskGroup.Builder().task(new ExecuteEventsTask(() -> POSITIVE_ENCHANTED_EVENTS, 3)).task(new MessageTask(VaultEvent.EventDisplayType.CHAT_MESSAGE_TARGET, (TextComponent)new TextComponent("The dancing cockroaches are fond towards you and bless each player with 3 random positive events!").m_130940_(ChatFormatting.GOLD))).build(), 1.0).task(new TaskGroup.Builder().task(new ExecuteEventsTask(() -> NEGATIVE_ENCHANTED_EVENTS, 3)).task(new MessageTask(VaultEvent.EventDisplayType.CHAT_MESSAGE_TARGET, (TextComponent)new TextComponent("The dancing cockroaches hate your guts and curse everyone in the vault with 3 random negative events!").m_130940_(ChatFormatting.RED))).build(), 1.0).build()).build("La Cucaracha", new TextComponent("Cha Cha Cha")), 3.0);
        if (LoadingModList.get().getModFileById("cloudstorage") != null) {
            CloudStorageEvents.init();
        }
        if (LoadingModList.get().getModFileById("wildbackport") != null) {
            WildBackportEvents.init();
        }
        if (LoadingModList.get().getModFileById("thermal") != null) {
            ThermalEvents.init();
        }
    }
}

