/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives.data.alchemy;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.iwolfking.woldsvaults.config.AlchemyObjectiveConfig;

public class AlchemyTasks {
    public static void initServer(VirtualWorld world, Vault vault, Objective objective, AlchemyObjectiveConfig.Entry config) {
        AlchemyTasks.generateChestIngredients(world, vault, objective, config.getChestProbability(), config.getChestIngredients());
        AlchemyTasks.generateCoinIngredients(world, vault, objective, config.getCoinProbability(), config.getCoinIngredients());
        AlchemyTasks.generateOreIngredients(world, vault, objective, config.getOreProbabiltiy(), config.getOreIngredients());
    }

    private static void generateChestIngredients(VirtualWorld virtualWorld, Vault vault, Objective objective, float probability, WeightedList<ItemStack> entries) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register((Object)objective, data -> {
            if (data.getPlayer().f_19853_ == virtualWorld && !(data.getRandom().nextDouble() >= (double)probability)) {
                entries.getRandom(data.getRandom()).ifPresent(itemStack -> {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    items.add(AlchemyTasks.createStack(vault, itemStack));
                    data.getLoot().addAll(items);
                });
            }
        });
    }

    private static void generateCoinIngredients(VirtualWorld world, Vault vault, Objective objective, float probability, WeightedList<ItemStack> entries) {
        CommonEvents.COIN_STACK_LOOT_GENERATION.post().register((Object)objective, data -> {
            if (data.getPlayer().f_19853_ == world && !(data.getRandom().nextDouble() >= (double)probability)) {
                entries.getRandom(data.getRandom()).ifPresent(itemStack -> data.getLoot().add(AlchemyTasks.createStack(vault, itemStack)));
            }
        });
    }

    private static void generateOreIngredients(VirtualWorld world, Vault vault, Objective objective, float probability, WeightedList<ItemStack> entries) {
        CommonEvents.PLAYER_MINE.register((Object)objective, EventPriority.LOW, data -> {
            if (data.getPlayer().f_19853_ == world && data.getState().m_60734_() instanceof VaultOreBlock && ((Boolean)data.getState().m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) {
                ChunkRandom random = ChunkRandom.any();
                BlockPos pos = data.getPos();
                random.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 110307L);
                if (!(random.nextDouble() >= (double)probability)) {
                    entries.getRandom((RandomGenerator)world.m_5822_()).ifPresent(itemStack -> {
                        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                        items.add(AlchemyTasks.createStack(vault, itemStack));
                        items.forEach(item -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)item));
                    });
                }
            }
        });
    }

    private static ItemStack createStack(Vault vault, ItemStack stack) {
        stack = stack.m_41777_();
        stack.m_41784_().m_128359_("VaultId", ((UUID)vault.get(Vault.ID)).toString());
        return stack;
    }

    public static class MobEntry {
        public final ItemStack item;
        public final List<EntityPredicate> group;

        public MobEntry(ItemStack item, EntityPredicate ... entityPredicate) {
            this.item = item;
            this.group = List.of(entityPredicate);
        }
    }
}

