/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives.data.bosses.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.client.render.DynamicHumanoidModelLayer;
import iskallia.vault.entity.model.FighterModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.objectives.data.bosses.WoldBoss;

public class WoldBossRenderer
extends LivingEntityRenderer<LivingEntity, HumanoidModel<LivingEntity>> {
    public static final ResourceLocation TEXTURE = WoldsVaults.id("textures/entity/wold.png");
    private final DynamicHumanoidModelLayer<LivingEntity, HumanoidModel<LivingEntity>, HumanoidModel<LivingEntity>> armorLayer;
    private final HumanoidModel<LivingEntity> thisModel;
    private final PlayerModel<LivingEntity> playerModel;
    private final PlayerModel<LivingEntity> playerSlimModel;

    public WoldBossRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayer) {
        this(context, modelLayer, false);
    }

    public WoldBossRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayer, boolean slim) {
        super(context, (EntityModel)new FighterModel(context.m_174023_(modelLayer), slim), 0.5f);
        this.armorLayer = new DynamicHumanoidModelLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171167_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171168_)));
        this.m_115326_((RenderLayer)this.armorLayer);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.thisModel = (HumanoidModel)this.f_115290_;
        this.playerModel = new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false);
        this.playerSlimModel = new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.armorLayer.setSlim(slim);
    }

    protected boolean m_6512_(LivingEntity entity) {
        return entity.m_20151_() && super.m_6512_(entity);
    }

    public void m_7392_(LivingEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        if (entity instanceof WoldBoss) {
            WoldBoss woldBoss = (WoldBoss)entity;
            this.setModelVisibilities((LivingEntity)woldBoss);
            this.f_115290_ = this.playerModel;
            super.m_7392_((LivingEntity)woldBoss, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        }
    }

    public Vec3 getRenderOffset(WoldBoss entityIn, float partialTicks) {
        return entityIn.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entityIn, partialTicks);
    }

    private void setModelVisibilities(LivingEntity entity) {
        if (entity instanceof WoldBoss) {
            WoldBoss woldBoss = (WoldBoss)entity;
            WoldBossRenderer.setVisibilities(this.playerModel, (LivingEntity)woldBoss);
        }
    }

    private static void setVisibilities(PlayerModel<?> playerModel, LivingEntity entity) {
        playerModel.m_8009_(true);
        playerModel.f_102809_.f_104207_ = true;
        playerModel.f_103378_.f_104207_ = true;
        playerModel.f_103376_.f_104207_ = true;
        playerModel.f_103377_.f_104207_ = true;
        playerModel.f_103374_.f_104207_ = true;
        playerModel.f_103375_.f_104207_ = true;
        playerModel.f_102817_ = entity.m_6047_();
        HumanoidModel.ArmPose mainArmPose = WoldBossRenderer.getArmPose(entity, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose offHandPose = WoldBossRenderer.getArmPose(entity, InteractionHand.OFF_HAND);
        if (mainArmPose.m_102897_()) {
            HumanoidModel.ArmPose armPose = offHandPose = entity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (entity.m_5737_() == HumanoidArm.RIGHT) {
            playerModel.f_102816_ = mainArmPose;
            playerModel.f_102815_ = offHandPose;
        } else {
            playerModel.f_102816_ = offHandPose;
            playerModel.f_102815_ = mainArmPose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand) {
        ItemStack itemstack = entity.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (entity.m_7655_() == hand && entity.m_21212_() > 0) {
            UseAnim useaction = itemstack.m_41780_();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && hand == entity.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!entity.f_20911_ && itemstack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(LivingEntity entity) {
        if (entity instanceof WoldBoss) {
            return TEXTURE;
        }
        return MissingTextureAtlasSprite.m_118071_();
    }

    protected void m_7523_(LivingEntity entity, PoseStack matrixStack, float age, float yaw, float pTicks) {
        float f = entity.m_20998_(pTicks);
        if (entity.m_21255_()) {
            super.m_7523_(entity, matrixStack, age, yaw, pTicks);
            float f3 = (float)entity.m_21256_() + pTicks;
            float f2 = Mth.m_14036_((float)(f3 * f3 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entity.m_21209_()) {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - entity.m_146909_())));
            }
            Vec3 vec3 = entity.m_20252_(pTicks);
            Vec3 vec31 = entity.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_(entity, matrixStack, age, yaw, pTicks);
            float f3 = entity.m_20069_() ? -90.0f - entity.m_146909_() : -90.0f;
            float f2 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f2));
            if (entity.m_6067_()) {
                matrixStack.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_(entity, matrixStack, age, yaw, pTicks);
        }
    }

    protected void m_7546_(LivingEntity pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        super.m_7546_(pLivingEntity, pMatrixStack, pPartialTickTime);
        pMatrixStack.m_85841_(2.0f, 2.0f, 2.0f);
    }
}

