/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.crystal;

import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.LayoutModificationItem;

public class LayoutModificationRecipe
extends VanillaAnvilRecipe {
    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        if (primary.m_41720_() instanceof VaultCrystalItem && secondary.m_41720_() == ModItems.LAYOUT_MANIPULATOR) {
            ItemStack output = primary.m_41777_();
            CrystalData data = CrystalData.read((ItemStack)output);
            if (data.getProperties().isUnmodifiable()) {
                return false;
            }
            if (LayoutModificationItem.getLayout(secondary).isEmpty()) {
                return false;
            }
            CrystalLayout layout = LayoutModificationItem.getLayout(secondary).get();
            data.setLayout(layout);
            data.write(output);
            context.setOutput(output);
            context.onTake(context.getTake().append(() -> {
                context.getInput()[0].m_41774_(1);
                context.getInput()[1].m_41774_(1);
            }));
            return true;
        }
        return false;
    }

    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ItemStack crystal = VaultCrystalItem.create(crystalData -> crystalData.getProperties().setLevel(Integer.valueOf(0)));
        ArrayList<ItemStack> secondaries = new ArrayList<ItemStack>();
        secondaries.add(LayoutModificationItem.create("infinite", 1, 1));
        secondaries.add(LayoutModificationItem.create("circle", 1, 8));
        secondaries.add(LayoutModificationItem.create("polygon", 1, 12));
        secondaries.add(LayoutModificationItem.create("spiral", 1, 4));
        for (ItemStack secondary : secondaries) {
            ItemStack crystalOutput = VaultCrystalItem.create(crystalData -> {
                crystalData.getProperties().setLevel(Integer.valueOf(0));
                CrystalLayout layout = LayoutModificationItem.getLayout(secondary).orElse((CrystalLayout)new ClassicInfiniteCrystalLayout(1));
                crystalData.setLayout(layout);
            });
            outputs.add(crystalOutput);
        }
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(List.of(crystal), secondaries, outputs)));
    }
}

