/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.crystal;

import iskallia.vault.VaultMod;
import iskallia.vault.config.VaultCrystalConfig;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.modifier.GroupedModifier;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.item.data.InscriptionData;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.gear.VaultMapItem;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.SettableValueVaultModifier;
import xyz.iwolfking.woldsvaults.modifiers.vault.map.modifiers.GreedyVaultModifier;
import xyz.iwolfking.woldsvaults.modifiers.vault.map.modifiers.InscriptionCrystalModifierSettable;

public class MapModificationRecipe
extends VanillaAnvilRecipe {
    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        boolean hasGreedy = false;
        Item item = primary.m_41720_();
        if (item instanceof VaultCrystalItem) {
            VaultCrystalItem crystal = (VaultCrystalItem)item;
            if (secondary.m_41720_() == ModItems.MAP) {
                ItemStack output = primary.m_41777_();
                CrystalData data = CrystalData.read((ItemStack)output);
                if (data.getProperties().isUnmodifiable()) {
                    return false;
                }
                Item item2 = secondary.m_41720_();
                if (!(item2 instanceof VaultMapItem)) {
                    return false;
                }
                VaultMapItem map = (VaultMapItem)item2;
                block0: for (VaultModifierStack modifierStack : data.getModifiers()) {
                    VaultModifier vaultModifier = modifierStack.getModifier();
                    if (vaultModifier instanceof GroupedModifier) {
                        GroupedModifier groupedModifier = (GroupedModifier)vaultModifier;
                        for (VaultModifier childMod : ((GroupedModifier.Properties)groupedModifier.properties()).getChildren()) {
                            if (!(childMod instanceof GreedyVaultModifier)) continue;
                            hasGreedy = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (!(modifierStack.getModifier() instanceof GreedyVaultModifier)) continue;
                    hasGreedy = true;
                    break;
                }
                if (data.getProperties().getLevel().isPresent() && (Integer)data.getProperties().getLevel().get() < 100) {
                    return false;
                }
                if (!hasGreedy) {
                    return false;
                }
                VaultGearData mapData = VaultGearData.read((ItemStack)secondary);
                Optional prefixSlots = mapData.getFirstValue(iskallia.vault.init.ModGearAttributes.PREFIXES);
                Optional suffixSlots = mapData.getFirstValue(iskallia.vault.init.ModGearAttributes.SUFFIXES);
                if (prefixSlots.isEmpty() || suffixSlots.isEmpty()) {
                    return false;
                }
                int numberOfPrefixes = mapData.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
                int numberOfSuffixes = mapData.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
                boolean unfinishedMap = false;
                if ((Integer)prefixSlots.get() != numberOfPrefixes || (Integer)suffixSlots.get() != numberOfSuffixes) {
                    unfinishedMap = true;
                }
                String themeId = mapData.getFirstValue(ModGearAttributes.THEME).orElse(null);
                String themePoolId = mapData.getFirstValue(ModGearAttributes.THEME_POOL).orElse(null);
                String objectiveId = mapData.getFirstValue(ModGearAttributes.OBJECTIVE).orElse(null);
                if (themeId != null) {
                    theme = new ValueCrystalTheme(new ResourceLocation(themeId));
                    data.setTheme((CrystalTheme)theme);
                } else if (themePoolId != null) {
                    theme = new PoolCrystalTheme(new ResourceLocation(themePoolId));
                    data.setTheme((CrystalTheme)theme);
                } else {
                    return false;
                }
                if (objectiveId != null) {
                    if (CrystalData.OBJECTIVE.getValue(objectiveId) != null) {
                        CrystalObjective obj;
                        VaultCrystalConfig.ObjectiveEntry entry;
                        CrystalObjective objective = (CrystalObjective)CrystalData.OBJECTIVE.getValue(objectiveId);
                        if (ModConfigs.VAULT_CRYSTAL.OBJECTIVES.containsKey(VaultMod.id((String)objectiveId)) && (entry = (VaultCrystalConfig.ObjectiveEntry)((LevelEntryList)ModConfigs.VAULT_CRYSTAL.OBJECTIVES.get(VaultMod.id((String)objectiveId))).getForLevel(data.getProperties().getLevel().orElse(0).intValue()).orElse(null)) != null && (obj = (CrystalObjective)entry.pool.getRandom().orElse(null)) != null) {
                            objective = obj;
                        }
                        data.setObjective(objective);
                    }
                } else {
                    return false;
                }
                MapModificationRecipe.applySpecialModifiers(data, mapData, VaultGearModifier.AffixType.PREFIX, context, output, unfinishedMap);
                MapModificationRecipe.applySpecialModifiers(data, mapData, VaultGearModifier.AffixType.SUFFIX, context, output, unfinishedMap);
                MapModificationRecipe.applySpecialModifiers(data, mapData, VaultGearModifier.AffixType.IMPLICIT, context, output, unfinishedMap);
                data.getProperties().setUnmodifiable(true);
                data.write(output);
                context.setOutput(output);
                context.onTake(context.getTake().append(() -> {
                    context.getInput()[0].m_41774_(1);
                    context.getInput()[1].m_41774_(1);
                }));
                return true;
            }
        }
        return false;
    }

    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ItemStack map = new ItemStack((ItemLike)ModItems.MAP);
        Item item = map.m_41720_();
        if (item instanceof IdentifiableItem) {
            IdentifiableItem identifiableItem = (IdentifiableItem)item;
            identifiableItem.instantIdentify(null, map);
        }
        VaultGearData mapData = VaultGearData.read((ItemStack)map);
        ItemStack crystal = VaultCrystalItem.create(crystalData -> {
            crystalData.getModifiers().add(new VaultModifierStack(VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"greedy")), 1));
            crystalData.getProperties().setLevel(Integer.valueOf(100));
        });
        ItemStack crystalOutput = VaultCrystalItem.create(crystalData -> {
            crystalData.getModifiers().add(new VaultModifierStack(VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"greedy")), 1));
            crystalData.getProperties().setLevel(Integer.valueOf(100));
            MapModificationRecipe.applySpecialModifiers(crystalData, mapData, VaultGearModifier.AffixType.IMPLICIT, null, null, false);
            MapModificationRecipe.applySpecialModifiers(crystalData, mapData, VaultGearModifier.AffixType.PREFIX, null, null, false);
            MapModificationRecipe.applySpecialModifiers(crystalData, mapData, VaultGearModifier.AffixType.SUFFIX, null, null, false);
            crystalData.getProperties().setUnmodifiable(true);
        });
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(List.of(crystal), List.of(map), List.of(crystalOutput))));
    }

    public static boolean applySpecialModifiers(CrystalData data, VaultGearData mapData, VaultGearModifier.AffixType affixType, AnvilContext context, ItemStack output, boolean shouldReduceValues) {
        for (VaultGearModifier mod : mapData.getModifiers(affixType)) {
            VaultModifier vaultMod = VaultModifierRegistry.get((ResourceLocation)mod.getModifierIdentifier());
            if (vaultMod instanceof SettableValueVaultModifier) {
                float value;
                SettableValueVaultModifier settableValueVaultModifier = (SettableValueVaultModifier)vaultMod;
                Object object = mod.getValue();
                if (object instanceof Integer) {
                    Integer integerValue = (Integer)object;
                    value = Float.valueOf(integerValue.intValue()).floatValue();
                } else {
                    value = ((Float)mod.getValue()).floatValue();
                }
                if (shouldReduceValues) {
                    value *= 0.25f;
                }
                ((SettableValueVaultModifier.Properties)settableValueVaultModifier.properties()).setValue(Float.valueOf(value));
                if (vaultMod instanceof InscriptionCrystalModifierSettable) {
                    InscriptionCrystalModifierSettable inscriptionCrystalModifierSettable = (InscriptionCrystalModifierSettable)vaultMod;
                    InscriptionData inscriptionData = ((InscriptionCrystalModifierSettable.Properties)inscriptionCrystalModifierSettable.properties()).getData();
                    inscriptionData.apply((Player)context.getPlayer().orElse(null), output, data);
                    continue;
                }
                VaultModifierStack stack = new VaultModifierStack((VaultModifier)settableValueVaultModifier, 1);
                data.getModifiers().add(stack);
                continue;
            }
            if (vaultMod == null) continue;
            VaultModifierStack stack = new VaultModifierStack(vaultMod, 1);
            data.getModifiers().add(stack);
        }
        return true;
    }
}

