/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.gear;

import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.gear.VaultCharmItem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.gear.VaultMapItem;

public class GearRepairAdderRecipe
extends VanillaAnvilRecipe {
    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        if (primary.m_41720_() instanceof VaultGearItem && secondary.m_41720_() == ModItems.REPAIR_AUGMENTER) {
            ItemStack output = primary.m_41777_();
            VaultGearData gear = VaultGearData.read((ItemStack)output);
            int currentRepairSlotCount = gear.getRepairSlots();
            if (currentRepairSlotCount >= 10 || !gear.isModifiable()) {
                return false;
            }
            gear.setRepairSlots(currentRepairSlotCount + 1);
            gear.write(output);
            context.setOutput(output);
            context.onTake(context.getTake().append(() -> {
                context.getInput()[0].m_41774_(1);
                context.getInput()[1].m_41774_(1);
            }));
            return true;
        }
        return false;
    }

    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        List<ItemStack> repairableItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> {
            VaultGearItem vaultGearItem;
            return item instanceof VaultGearItem && (vaultGearItem = (VaultGearItem)item).canStoreRepairSlots(item.m_7968_());
        }).map(Item::m_7968_).peek(stack -> {
            Item patt2596$temp = stack.m_41720_();
            if (patt2596$temp instanceof IdentifiableItem) {
                IdentifiableItem identifiableItem = (IdentifiableItem)patt2596$temp;
                if (!(stack.m_41720_() instanceof VaultCharmItem) && !(stack.m_41720_() instanceof VaultMapItem)) {
                    identifiableItem.instantIdentify(null, stack);
                }
            }
        }).toList();
        ItemStack secondary = new ItemStack((ItemLike)ModItems.REPAIR_AUGMENTER);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack input : repairableItems) {
            VaultGearData data = VaultGearData.read((ItemStack)input);
            data.setRepairSlots(data.getRepairSlots() + 1);
            ItemStack output = input.m_41777_();
            data.write(output);
            outputs.add(output);
        }
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(repairableItems, List.of(secondary), outputs)));
    }
}

