/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.iwolfking.woldsvaults.init.ModRecipeSerializers;
import xyz.iwolfking.woldsvaults.init.ModRecipeTypes;

public class InfuserRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int inputCount;
    private final Ingredient catalyst;
    private final int infuseDuration;

    public InfuserRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output, int inputCount, Ingredient catalyst, int infuseDuration) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
        this.output = output;
        this.inputCount = inputCount;
        this.catalyst = catalyst;
        this.infuseDuration = infuseDuration;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.INFUSER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.INFUSER;
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack input = inventory.getStackInSlot(0);
        ItemStack catalyst = inventory.getStackInSlot(1);
        return ((Ingredient)this.inputs.get(0)).test(input) && this.catalyst.test(catalyst);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public int getInfuseDuration() {
        return this.infuseDuration;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<InfuserRecipe> {
        public InfuserRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int inputCount = GsonHelper.m_13824_((JsonObject)json, (String)"inputCount", (int)10000);
            Ingredient catalyst = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            int infuseDuration = GsonHelper.m_13927_((JsonObject)json, (String)"infuseDuration");
            return new InfuserRecipe(recipeId, input, output, inputCount, catalyst, infuseDuration);
        }

        public InfuserRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int inputCount = buffer.readInt();
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int infuseDuration = buffer.readInt();
            return new InfuserRecipe(recipeId, input, output, inputCount, catalyst, infuseDuration);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfuserRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.inputCount);
            recipe.catalyst.m_43923_(buffer);
            buffer.writeInt(recipe.infuseDuration);
        }
    }
}

