/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.init.ModRecipeSerializers;

public class InfuserRecipeBuilder
implements RecipeBuilder {
    private final int infuseDuration;
    private final int inputCount;
    private final Ingredient ingredient;
    private final Ingredient catalyst;
    private final Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public InfuserRecipeBuilder(ItemLike ingredient, ItemLike catalyst, ItemLike result, int infuseDuration, int inputCount) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.catalyst = Ingredient.m_43929_((ItemLike[])new ItemLike[]{catalyst});
        this.result = result.m_5456_();
        this.infuseDuration = infuseDuration;
        this.inputCount = inputCount;
    }

    public RecipeBuilder m_142284_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_142409_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.infuseDuration, this.inputCount, this.ingredient, this.catalyst, this.result, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + pRecipeId.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int infuseDuration;
        private final int inputCount;
        private final Ingredient ingredient;
        private final Ingredient catalyst;
        private final Item result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, int infuseDuration, int inputCount, Ingredient ingredient, Ingredient catalyst, Item result, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.infuseDuration = infuseDuration;
            this.inputCount = inputCount;
            this.ingredient = ingredient;
            this.catalyst = catalyst;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.addProperty("infuseDuration", (Number)this.infuseDuration);
            pJson.addProperty("inputCount", (Number)this.inputCount);
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.add("catalyst", this.catalyst.m_43942_());
            JsonObject obj = new JsonObject();
            obj.addProperty("item", this.result.getRegistryName().toString());
            pJson.add("result", (JsonElement)obj);
        }

        public ResourceLocation m_6445_() {
            return WoldsVaults.id(this.result.getRegistryName().m_135815_() + "_infusing");
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipeSerializers.INFUSER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

