/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class NbtAwareRecipe
implements FinishedRecipe {
    private final FinishedRecipe base;
    private final Map<Character, IngredientWithNBT> nbtOverrides;

    public NbtAwareRecipe(FinishedRecipe base, Map<Character, IngredientWithNBT> overrides) {
        this.base = base;
        this.nbtOverrides = overrides;
    }

    public void m_7917_(JsonObject json) {
        this.base.m_7917_(json);
        JsonObject key = json.getAsJsonObject("key");
        for (Map.Entry<Character, IngredientWithNBT> entry : this.nbtOverrides.entrySet()) {
            key.add(String.valueOf(entry.getKey()), (JsonElement)entry.getValue().toJson());
        }
    }

    public ResourceLocation m_6445_() {
        return this.base.m_6445_();
    }

    public RecipeSerializer<?> m_6637_() {
        return this.base.m_6637_();
    }

    public JsonObject m_5860_() {
        return this.base.m_5860_();
    }

    public ResourceLocation m_6448_() {
        return this.base.m_6448_();
    }

    public record IngredientWithNBT(String itemId, String nbtJson) {
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "forge:nbt");
            obj.addProperty("item", this.itemId);
            obj.add("nbt", JsonParser.parseString((String)this.nbtJson));
            return obj;
        }
    }
}

