/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.tool;

import iskallia.vault.gear.data.ToolGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import xyz.iwolfking.woldsvaults.init.ModItems;

public class ToolCapacityAdderRecipe
extends VanillaAnvilRecipe {
    private static final String REINFORCEMENT_COUNT_TAG = "woldsvaults.reinforcements_applied";

    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        Item item = primary.m_41720_();
        if (item instanceof ToolItem) {
            ToolItem tool = (ToolItem)item;
            if (secondary.m_41720_() == ModItems.RESONATING_REINFORCEMENT) {
                ItemStack output = primary.m_41777_();
                VaultGearData gear = ToolGearData.read((ItemStack)output);
                int toolCapacity = 0;
                if (!gear.getFirstValue(ModGearAttributes.TOOL_CAPACITY).isPresent()) {
                    return false;
                }
                toolCapacity = (Integer)gear.getFirstValue(ModGearAttributes.TOOL_CAPACITY).get();
                CompoundTag tag = output.m_41784_();
                int reinforcementsApplied = 0;
                if (tag.m_128441_(REINFORCEMENT_COUNT_TAG)) {
                    reinforcementsApplied = tag.m_128451_(REINFORCEMENT_COUNT_TAG);
                }
                if (reinforcementsApplied >= 2) {
                    return false;
                }
                gear.createOrReplaceAttributeValue(ModGearAttributes.TOOL_CAPACITY, (Object)(toolCapacity + 10));
                gear.write(output);
                tag.m_128405_(REINFORCEMENT_COUNT_TAG, ++reinforcementsApplied);
                context.setOutput(output);
                context.onTake(context.getTake().append(() -> {
                    context.getInput()[0].m_41774_(1);
                    context.getInput()[1].m_41774_(1);
                }));
                return true;
            }
        }
        return false;
    }

    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<ItemStack> secondary = List.of(new ItemStack((ItemLike)ModItems.RESONATING_REINFORCEMENT));
        for (ToolMaterial material : ToolMaterial.values()) {
            for (ToolType type : ToolType.values()) {
                inputs.add(ToolItem.create((ToolMaterial)material, (ToolType)type));
                ItemStack output = ToolItem.create((ToolMaterial)material, (ToolType)type);
                ToolItem.addCapacity((ItemStack)output, (int)10);
                outputs.add(output);
            }
        }
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(inputs, secondary, outputs)));
    }
}

