/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.recipes.tool;

import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.ToolGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.woldsvaults.items.ToolModifierNullifyingItem;

public class ToolModifierNullifierRecipe
extends VanillaAnvilRecipe {
    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        if (primary.m_41720_() instanceof ToolItem && secondary.m_41720_() instanceof ToolModifierNullifyingItem) {
            ItemStack output = primary.m_41777_();
            ItemStack input = secondary.m_41777_();
            VaultGearAttribute<?> attributeToRemove = ToolModifierNullifyingItem.getModifierTag(input);
            if (attributeToRemove == null) {
                return false;
            }
            VaultGearData gear = ToolGearData.read((ItemStack)output);
            ArrayList<VaultGearModifier> modifiersRemoved = new ArrayList<VaultGearModifier>();
            for (VaultGearModifier mod : gear.getAllModifierAffixes()) {
                if (!mod.getAttribute().equals(attributeToRemove)) continue;
                modifiersRemoved.add(mod);
            }
            if (modifiersRemoved.isEmpty()) {
                return false;
            }
            for (VaultGearModifier mod : modifiersRemoved) {
                gear.removeModifier(mod);
            }
            gear.write(output);
            context.setOutput(output);
            context.onTake(context.getTake().append(() -> {
                context.getInput()[0].m_41774_(1);
                context.getInput()[1].m_41774_(1);
            }));
            return true;
        }
        return false;
    }

    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondaries = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (String modifier : ToolModifierNullifyingItem.CHISELING_MODIFIER_TYPES) {
            secondaries.add(ToolModifierNullifyingItem.create(modifier));
        }
        for (ToolMaterial material : ToolMaterial.values()) {
            for (ToolType type : ToolType.values()) {
                ItemStack input = ToolItem.create((ToolMaterial)material, (ToolType)type);
                inputs.add(input);
                ItemStack output = ToolItem.create((ToolMaterial)material, (ToolType)type);
                outputs.add(output);
            }
        }
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(inputs, secondaries, outputs)));
    }
}

