/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.teams.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class VaultTeamsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultTeamsPointsData";
    protected Map<String, Integer> playerTeamData = new HashMap<String, Integer>();

    private VaultTeamsData() {
    }

    private VaultTeamsData(CompoundTag tag) {
        this.load(tag);
    }

    public void load(CompoundTag tag) {
        this.playerTeamData.clear();
        ListTag teamsData = tag.m_128437_("teams", 10);
        for (int i = 0; i < teamsData.size(); ++i) {
            CompoundTag teamTag = teamsData.m_128728_(i);
            String teamName = teamTag.m_128461_("team");
            Integer points = teamTag.m_128451_("points");
            this.playerTeamData.put(teamName, points);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag teamPoints = new ListTag();
        this.playerTeamData.forEach((teamName, points) -> {
            CompoundTag teamTag = new CompoundTag();
            teamTag.m_128359_("team", teamName);
            teamTag.m_128405_("points", points.intValue());
            teamPoints.add((Object)teamTag);
        });
        tag.m_128365_("teams", (Tag)teamPoints);
        return tag;
    }

    public static VaultTeamsData get(ServerLevel level) {
        return VaultTeamsData.get(level.m_142572_());
    }

    public static VaultTeamsData get(MinecraftServer server) {
        return (VaultTeamsData)server.m_129783_().m_8895_().m_164861_(VaultTeamsData::new, VaultTeamsData::new, DATA_NAME);
    }

    public void addPointsToTeam(String teamName, int points) {
        if (this.playerTeamData.containsKey(teamName)) {
            this.playerTeamData.put(teamName, this.playerTeamData.get(teamName) + points);
        } else {
            this.playerTeamData.put(teamName, points);
        }
        this.m_77760_(true);
    }

    public void removePointsFromTeam(String teamName, int points) {
        if (this.playerTeamData.containsKey(teamName)) {
            this.playerTeamData.put(teamName, this.playerTeamData.get(teamName) - points);
        }
        this.m_77760_(true);
    }

    public void setPointsForTeam(String teamName, int points) {
        this.playerTeamData.put(teamName, points);
        this.m_77760_(true);
    }

    public int getPointsForTeam(String teamName) {
        return this.playerTeamData.getOrDefault(teamName, 0);
    }
}

