/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.util.SettingsFrom;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class P2PTestPlots {
    @TestPlot(value="p2p_me")
    public static void me(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.ME_P2P_TUNNEL);
        plot.cable(origin.m_142125_().m_142125_()).part(Direction.WEST, AEParts.IMPORT_BUS);
        plot.chest(origin.m_142125_().m_142125_().m_142125_(), new ItemStack((ItemLike)Items.f_41829_));
        plot.cable(origin.m_142126_().m_142126_()).part(Direction.EAST, AEParts.STORAGE_BUS);
        plot.chest(origin.m_142126_().m_142126_().m_142126_(), new ItemStack[0]);
        plot.part(origin, Direction.UP, AEParts.STORAGE_BUS, storageBus -> storageBus.setPriority(1));
        plot.chest(origin.m_7494_(), new ItemStack[0]);
        plot.cable(origin.m_142126_().m_7494_());
        plot.cable(origin.m_142126_().m_142126_().m_7494_()).part(Direction.WEST, AEParts.QUARTZ_FIBER);
        plot.test(helper -> helper.m_177361_(() -> {
            helper.m_177440_(origin.m_142125_().m_142125_().m_142125_());
            helper.m_177242_(origin.m_142126_().m_142126_().m_142126_(), Items.f_41829_);
        }));
    }

    @TestPlot(value="p2p_items")
    public static void item(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.ITEM_P2P_TUNNEL);
        plot.hopper(origin.m_142125_().m_142125_(), Direction.EAST, new ItemStack((ItemLike)Items.f_41829_));
        BlockPos chestPos = origin.m_142126_().m_142126_();
        plot.chest(chestPos, new ItemStack[0]);
        plot.test(helper -> helper.m_177361_(() -> helper.m_177242_(chestPos, Items.f_41829_)));
    }

    @TestPlot(value="p2p_fluids")
    public static void fluid(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.FLUID_P2P_TUNNEL);
        BlockPos outputPos = origin.m_142126_().m_142126_();
        plot.block(outputPos, AEBlocks.SKY_STONE_TANK);
        plot.cable(origin.m_142125_().m_142125_()).part(Direction.EAST, AEParts.EXPORT_BUS, part -> part.getConfig().addFilter((Fluid)Fluids.f_76193_));
        plot.creativeEnergyCell(origin.m_142125_().m_142125_().m_7495_());
        plot.drive(origin.m_142125_().m_142125_().m_7494_()).addCreativeCell().add((Fluid)Fluids.f_76193_);
        plot.test(helper -> helper.m_177361_(() -> {
            SkyStoneTankBlockEntity tank = (SkyStoneTankBlockEntity)helper.m_177347_(outputPos);
            IFluidTank storage = tank.getStorage();
            helper.check(new FluidStack((Fluid)Fluids.f_76193_, 1).isFluidEqual(storage.getFluid()), "No water stored");
            helper.check(storage.getFluidAmount() > 0, "No amount >0 stored");
        }));
    }

    @TestPlot(value="p2p_energy")
    public static void energy(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.FE_P2P_TUNNEL);
        plot.block(origin.m_142125_().m_142125_(), AEBlocks.DEBUG_ENERGY_GEN);
        plot.block(origin.m_142126_().m_142126_(), AEBlocks.ENERGY_ACCEPTOR);
        BlockPos cellPos = origin.m_142126_().m_142126_().m_7494_();
        plot.block(cellPos, AEBlocks.ENERGY_CELL);
        MutableDouble cellEnergy = new MutableDouble(0.0);
        plot.test(helper -> helper.m_177425_().m_177544_(10).m_177552_(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.m_177347_(cellPos);
            cellEnergy.setValue(cell.getAECurrentPower());
        }).m_177544_(10).m_177552_(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.m_177347_(cellPos);
            helper.check(cell.getAECurrentPower() > cellEnergy.getValue(), "Cell should start charging through the P2P tunnel");
        }).m_177543_());
    }

    @TestPlot(value="p2p_light")
    public static void light(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.LIGHT_P2P_TUNNEL);
        plot.block(origin.m_142125_().m_142125_(), Blocks.f_50261_);
        BlockPos leverPos = origin.m_142125_().m_142125_().m_7494_();
        plot.block(leverPos, Blocks.f_50164_);
        BlockPos outputPos = origin.m_142126_().m_142126_();
        plot.test(helper -> {
            MutableInt lightLevel = new MutableInt(0);
            helper.m_177425_().m_177544_(20).m_177562_(() -> {
                lightLevel.setValue(helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos)));
                helper.m_177421_(leverPos);
            }).m_177552_(() -> {
                int newLightLevel = helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos));
                helper.check(newLightLevel > lightLevel.getValue(), "Light-Level didn't increase");
            }).m_177562_(() -> helper.m_177421_(leverPos)).m_177552_(() -> {
                int newLightLevel = helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos));
                helper.check(newLightLevel <= lightLevel.getValue(), "Light-Level didn't reset");
            }).m_177543_();
        });
    }

    private static <T extends P2PTunnelPart<?>> void placeTunnel(PlotBuilder plot, ItemDefinition<PartItem<T>> tunnel) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin);
        plot.cable(origin.m_142125_()).part(Direction.WEST, tunnel);
        plot.cable(origin.m_142126_()).part(Direction.EAST, tunnel);
        plot.afterGridInitAt(origin, (grid, gridNode) -> {
            BlockPos absOrigin = ((AEBasePart)gridNode.getOwner()).getBlockEntity().m_58899_();
            P2PService p2p = P2PService.get(grid);
            P2PTunnelPart inputTunnel = null;
            P2PTunnelPart outputTunnel = null;
            for (P2PTunnelPart p2pPart : grid.getMachines(((PartItem)tunnel.m_5456_()).getPartClass())) {
                if (p2pPart.getBlockEntity().m_58899_().equals((Object)absOrigin.m_142125_())) {
                    inputTunnel = p2pPart;
                    continue;
                }
                if (!p2pPart.getBlockEntity().m_58899_().equals((Object)absOrigin.m_142126_())) continue;
                outputTunnel = p2pPart;
            }
            Objects.requireNonNull(inputTunnel, "inputTunnel");
            Objects.requireNonNull(outputTunnel, "outputTunnel");
            inputTunnel.setFrequency(p2p.newFrequency());
            p2p.updateFreq(inputTunnel, inputTunnel.getFrequency());
            CompoundTag settings = new CompoundTag();
            inputTunnel.exportSettings(SettingsFrom.MEMORY_CARD, settings);
            outputTunnel.importSettings(SettingsFrom.MEMORY_CARD, settings, null);
        });
    }
}

