/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.blocks;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinygates.blocks.AbstractGateBlockEntity;
import com.dannyandson.tinygates.blocks.Side;
import com.dannyandson.tinygates.gui.ClockBlockGUI;
import com.dannyandson.tinygates.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClockBlockEntity
extends AbstractGateBlockEntity {
    private int ticks = 20;
    private int tick = 0;
    private boolean input = false;

    public ClockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CLOCK_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.output > 0 ? RenderHelper.TEXTURES_CLOCK[RenderHelper.TEXTURES_CLOCK.length - 1] : RenderHelper.TEXTURES_CLOCK[Math.min(Math.floorDiv(this.tick * (RenderHelper.TEXTURES_CLOCK.length - 1), this.ticks), RenderHelper.TEXTURES_CLOCK.length - 1)];
    }

    @Override
    public boolean onNeighborChange(@Nullable BlockPos neighbor) {
        Direction backDirection = this.getDirectionFromSide(Side.BACK);
        int backSignal = this.m_58904_().m_46681_(this.m_58899_().m_142300_(backDirection), backDirection);
        this.input = backSignal > 0;
        return false;
    }

    public boolean tick() {
        if (!this.input) {
            ++this.tick;
            if (this.tick >= this.ticks) {
                this.output = 15;
                this.tick = 0;
                return true;
            }
            if (this.output > 0) {
                this.output = 0;
                return true;
            }
            this.sync();
        }
        return false;
    }

    public void use() {
        if (this.m_58904_().f_46443_) {
            ClockBlockGUI.open(this);
        }
    }

    public Integer getTicks() {
        return this.ticks;
    }

    public void setTicks(Integer ticks) {
        if (ticks < this.tick) {
            this.tick = 0;
        }
        this.ticks = ticks < 2 ? 2 : (ticks > 200 ? 200 : ticks);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ticks = nbt.m_128451_("ticks");
        this.tick = nbt.m_128451_("tick");
        this.input = nbt.m_128471_("input");
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("ticks", this.ticks);
        nbt.m_128405_("tick", this.tick);
        nbt.m_128379_("input", this.input);
    }
}

