/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.blocks;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinygates.blocks.AbstractGateBlockEntity;
import com.dannyandson.tinygates.blocks.Side;
import com.dannyandson.tinygates.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EdgeDetectorBlockEntity
extends AbstractGateBlockEntity {
    private boolean rising = true;
    private boolean input = false;
    private int ticks = 0;

    public EdgeDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.EDGE_DETECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.output > 0 ? (this.rising ? RenderHelper.TEXTURE_RISING_ON : RenderHelper.TEXTURE_FALLING_ON) : (this.rising ? RenderHelper.TEXTURE_RISING_OFF : RenderHelper.TEXTURE_FALLING_OFF);
    }

    @Override
    public boolean onNeighborChange(@Nullable BlockPos neighbor) {
        Direction backDirection = this.getDirectionFromSide(Side.BACK);
        int backSignal = this.m_58904_().m_46681_(this.m_58899_().m_142300_(backDirection), backDirection);
        boolean previousinput = this.input;
        boolean bl = this.input = backSignal > 0;
        if (this.rising && !previousinput && this.input || !this.rising && previousinput && !this.input) {
            this.output = 15;
            this.ticks = 2;
            return true;
        }
        return false;
    }

    public boolean tick() {
        if (this.output > 0) {
            --this.ticks;
            if (this.ticks <= 0) {
                this.output = 0;
                return true;
            }
        }
        return false;
    }

    public void use() {
        this.rising = !this.rising;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.input = nbt.m_128471_("input");
        this.rising = nbt.m_128471_("rising");
        this.ticks = nbt.m_128451_("ticks");
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("input", this.input);
        nbt.m_128379_("rising", this.rising);
        nbt.m_128405_("ticks", this.ticks);
    }
}

