/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.network;

import com.dannyandson.tinygates.blocks.ClockBlockEntity;
import com.dannyandson.tinygates.gates.Clock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClockTickSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final int ticks;

    public ClockTickSync(BlockPos pos, int cellIndex, int ticks) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.ticks = ticks;
    }

    public ClockTickSync(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.cellIndex = buffer.readInt();
        this.ticks = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.cellIndex);
        buf.writeInt(this.ticks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity te = ((NetworkEvent.Context)ctx.get()).getSender().m_183503_().m_7702_(this.pos);
            if (this.cellIndex == -1) {
                if (te instanceof ClockBlockEntity) {
                    ClockBlockEntity clockBlockEntity = (ClockBlockEntity)te;
                    clockBlockEntity.setTicks(this.ticks);
                }
            } else {
                Clock.clockTickSync(te, this.cellIndex, this.ticks);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

