/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.client.events.EventTooltip;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.setup.ModSetup;
import com.direwolf20.laserio.util.MiscTools;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseFilter
extends Item {
    public BaseFilter() {
        super(new Item.Properties().m_41491_(ModSetup.ITEM_GROUP));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (world == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (!sneakPressed) {
            tooltip.add((Component)new TranslatableComponent("laserio.tooltip.item.show_settings").m_130940_(ChatFormatting.GRAY));
        } else {
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.type", ChatFormatting.GRAY.m_126665_());
            boolean allowMode = BaseFilter.getAllowList(stack);
            String allowString = allowMode ? "laserio.tooltip.item.filter.type.allow" : "laserio.tooltip.item.filter.type.deny";
            int allowColor = allowMode ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.RED.m_126665_();
            toWrite.m_7220_((Component)MiscTools.tooltipMaker(allowString, allowColor));
            tooltip.add((Component)toWrite);
            if (!(stack.m_41720_() instanceof FilterTag)) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.nbt", ChatFormatting.GRAY.m_126665_());
                boolean nbtMode = BaseFilter.getCompareNBT(stack);
                String nbtString = nbtMode ? "laserio.tooltip.item.filter.nbt.allow" : "laserio.tooltip.item.filter.nbt.deny";
                int nbtColor = nbtMode ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.RED.m_126665_();
                toWrite.m_7220_((Component)MiscTools.tooltipMaker(nbtString, nbtColor));
                tooltip.add((Component)toWrite);
            }
            if (!(stack.m_41720_() instanceof FilterTag)) {
                // empty if block
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        return Optional.of(new EventTooltip.CopyPasteTooltipComponent.Data(itemStack));
    }

    public static boolean getAllowList(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        return !compound.m_128441_("allowList") ? BaseFilter.setAllowList(stack, true) : compound.m_128471_("allowList");
    }

    public static boolean setAllowList(ItemStack stack, boolean allowList) {
        stack.m_41784_().m_128379_("allowList", allowList);
        return allowList;
    }

    public static boolean getCompareNBT(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        return !compound.m_128441_("compareNBT") ? BaseFilter.setCompareNBT(stack, false) : compound.m_128471_("compareNBT");
    }

    public static boolean setCompareNBT(ItemStack stack, boolean compareNBT) {
        stack.m_41784_().m_128379_("compareNBT", compareNBT);
        return compareNBT;
    }
}

