/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;

public class FilterCount
extends BaseFilter {
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterCountContainer(windowId, playerInventory, player, itemstack), (Component)new TranslatableComponent("")), buf -> {
            buf.m_130055_(itemstack);
            buf.m_130055_(ItemStack.f_41583_);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static int getSlotAmount(ItemStack stack, int getSlot) {
        CompoundTag compound = stack.m_41784_();
        ListTag countList = compound.m_128437_("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.m_128728_(i);
            int slot = countTag.m_128451_("Slot");
            if (slot != getSlot) continue;
            return countTag.m_128451_("MBAmount");
        }
        return 0;
    }

    public static void setSlotAmount(ItemStack stack, int getSlot, int setMBAmount) {
        CompoundTag compound = stack.m_41784_();
        ListTag countList = compound.m_128437_("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.m_128728_(i);
            int slot = countTag.m_128451_("Slot");
            if (slot != getSlot) continue;
            countTag.m_128405_("MBAmount", setMBAmount);
            if (setMBAmount == 0) {
                countTag.m_128405_("Count", 0);
                continue;
            }
            countTag.m_128405_("Count", Math.max(1, (int)Math.floor(setMBAmount / 1000)));
        }
    }

    public static int getSlotCount(ItemStack stack, int getSlot) {
        CompoundTag compound = stack.m_41784_();
        ListTag countList = compound.m_128437_("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.m_128728_(i);
            int slot = countTag.m_128451_("Slot");
            if (slot != getSlot) continue;
            return countTag.m_128451_("Count");
        }
        return 0;
    }

    public static void setSlotCount(ItemStack stack, int getSlot, int setCount) {
        CompoundTag compound = stack.m_41784_();
        ListTag countList = compound.m_128437_("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.m_128728_(i);
            int slot = countTag.m_128451_("Slot");
            if (slot != getSlot) continue;
            int mbAmt = FilterCount.getSlotAmount(stack, i);
            int mbCount = (int)Math.floor(mbAmt / 1000);
            if (mbCount == setCount || mbAmt == 0) {
                countTag.m_128405_("Count", setCount);
                continue;
            }
            countTag.m_128405_("Count", setCount);
            countTag.m_128405_("MBAmount", setCount * 1000 + mbAmt % 1000);
        }
    }

    public static FilterCountHandler getInventory(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        FilterCountHandler handler = new FilterCountHandler(15, stack);
        handler.deserializeNBT(compound.m_128469_("inv"));
        ListTag countList = compound.m_128437_("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.m_128728_(i);
            int slot = countTag.m_128451_("Slot");
            ItemStack itemStack = handler.getStackInSlot(slot);
            itemStack.m_41764_(countTag.m_128451_("Count"));
            handler.setStackInSlot(slot, itemStack);
        }
        return !compound.m_128441_("inv") ? FilterCount.setInventory(stack, new FilterCountHandler(15, stack)) : handler;
    }

    public static FilterCountHandler setInventory(ItemStack stack, FilterCountHandler handler) {
        stack.m_41784_().m_128365_("inv", (Tag)handler.serializeNBT());
        ListTag countList = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            CompoundTag countTag = new CompoundTag();
            ItemStack itemStack = handler.getStackInSlot(i);
            countTag.m_128405_("Slot", i);
            if (FilterCount.doesItemStackHoldFluids(itemStack)) {
                int mbAmt = FilterCount.getSlotAmount(stack, i);
                if (mbAmt > 0) {
                    countTag.m_128405_("Count", Math.max(1, (int)Math.floor(mbAmt / 1000)));
                    countTag.m_128405_("MBAmount", mbAmt);
                } else {
                    countTag.m_128405_("Count", itemStack.m_41613_());
                    countTag.m_128405_("MBAmount", itemStack.m_41613_() * 1000);
                }
            } else {
                countTag.m_128405_("Count", itemStack.m_41613_());
                countTag.m_128405_("MBAmount", 0);
            }
            countList.add((Object)countTag);
        }
        stack.m_41784_().m_128365_("counts", (Tag)countList);
        return handler;
    }

    public static boolean doesItemStackHoldFluids(ItemStack stack) {
        LazyOptional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)stack);
        if (!fluidHandlerLazyOptional.isPresent()) {
            return false;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.resolve().get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        return !fluidStack.isEmpty();
    }

    public static boolean getAllowList(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        return !compound.m_128441_("allowList") ? FilterCount.setAllowList(stack, true) : compound.m_128471_("allowList");
    }

    public static boolean setAllowList(ItemStack stack, boolean allowList) {
        stack.m_41784_().m_128379_("allowList", true);
        return true;
    }
}

