/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.client.ClientSetupEventHandler;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.config.CommonConfig;
import com.klikli_dev.modonomicon.config.ServerConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.item.ModonomiconCreativeModeTab;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CapabilityRegistry;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.klikli_dev.modonomicon.registry.MenuRegistry;
import com.klikli_dev.modonomicon.registry.SoundRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="modonomicon")
public class Modonomicon {
    public static final String MODID = "modonomicon";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreativeModeTab CREATIVE_MODE_TAB = new ModonomiconCreativeModeTab();
    public static Modonomicon INSTANCE;

    public Modonomicon() {
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.get().spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.get().spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemRegistry.ITEMS.register(modEventBus);
        MenuRegistry.MENUS.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onServerSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListener);
        MinecraftForge.EVENT_BUS.addListener(CommandRegistry::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(CommandRegistry::registerClientCommands);
        MinecraftForge.EVENT_BUS.addListener(BookDataManager.get()::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(MultiblockDataManager.get()::onDatapackSync);
        modEventBus.addListener(CapabilityRegistry::onRegisterCapabilities);
        MinecraftForge.EVENT_BUS.addListener(CapabilityRegistry::onPlayerClone);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityRegistry::onAttachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(CapabilityRegistry::onJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(BookUnlockCapability::onAdvancement);
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(ClientSetupEventHandler::onClientSetup);
            modEventBus.addListener(ClientSetupEventHandler::onModelBake);
            MinecraftForge.EVENT_BUS.addListener(BookDataManager.get()::onRecipesUpdated);
        }
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)BookDataManager.get());
        event.addListener((PreparableReloadListener)MultiblockDataManager.get());
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        Networking.registerMessages();
        LoaderRegistry.registerLoaders();
        LOGGER.info("Common setup complete.");
    }

    public void onServerSetup(FMLDedicatedServerSetupEvent event) {
        LOGGER.info("Dedicated server setup complete.");
    }
}

