/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

public abstract class MultiblockProvider
implements DataProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected String modid;
    protected BiConsumer<ResourceLocation, JsonObject> multiblockConsumer;

    public MultiblockProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    private Path getPath(Path dataFolder, ResourceLocation id) {
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/multiblocks").resolve(id.m_135815_() + ".json");
    }

    public void m_6865_(HashCache pCache) throws IOException {
        Path dataFolder = this.generator.m_123916_().resolve("data");
        HashSet set = Sets.newHashSet();
        this.multiblockConsumer = (id, recipe) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate multiblock " + id);
            }
            Path path = this.getPath(dataFolder, (ResourceLocation)id);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)pCache, (JsonElement)recipe, (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save multiblock to {}", (Object)path, (Object)ioexception);
            }
        };
        this.buildMultiblocks();
    }

    protected void add(ResourceLocation id, MultiblockBuilder multiblock) {
        this.add(id, multiblock.build());
    }

    protected void add(ResourceLocation id, JsonObject multiblock) {
        this.multiblockConsumer.accept(id, multiblock);
    }

    public String m_6055_() {
        return "Multiblocks: " + this.modid;
    }

    public abstract void buildMultiblocks();

    protected abstract class MultiblockBuilder {
        protected JsonObject multiblock = new JsonObject();

        public JsonObject build() {
            return this.build(true);
        }

        public JsonObject build(boolean displayGroundLayer) {
            return this.build(displayGroundLayer, 1);
        }

        public abstract JsonObject build(boolean var1, int var2);
    }

    protected class DenseMultiblockBuilder
    extends MultiblockBuilder {
        protected JsonObject multiblock = new JsonObject();

        public DenseMultiblockBuilder() {
            this.multiblock.addProperty("type", "modonomicon:dense");
            this.multiblock.add("pattern", (JsonElement)new JsonArray());
            this.multiblock.add("mapping", (JsonElement)new JsonObject());
        }

        private List<String> createPattern(String ... rows) {
            ArrayList<String> pattern = new ArrayList<String>();
            for (String row : rows) {
                pattern.add(row.replace(" ", "_"));
            }
            return pattern;
        }

        public DenseMultiblockBuilder layer(List<String> rows) {
            JsonArray pattern = this.multiblock.getAsJsonArray("pattern");
            JsonArray layer = new JsonArray();
            for (String row : rows) {
                layer.add(row);
            }
            pattern.add((JsonElement)layer);
            return this;
        }

        public DenseMultiblockBuilder layer(String ... rows) {
            return this.layer(this.createPattern(rows));
        }

        private DenseMultiblockBuilder map(String key, JsonObject stateMatcher) {
            JsonObject mapping = this.multiblock.getAsJsonObject("mapping");
            mapping.add(key, (JsonElement)stateMatcher);
            return this;
        }

        public DenseMultiblockBuilder any(char c) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:any");
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder block(char c, Supplier<? extends Block> b) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString());
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder block(char c, Supplier<? extends Block> b, Supplier<? extends Block> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString());
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)display.get()).toString() + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends Block> b, String matchState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstate");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString() + matchState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends Block> b, String matchState, Supplier<? extends Block> display) {
            return this.blockstate(c, b, matchState, display, "");
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends Block> b, String matchState, Supplier<? extends Block> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstate");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString() + matchState);
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)display.get()).toString() + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends Block> b, String matchState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstateproperty");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString() + matchState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends Block> b, String matchState, Supplier<? extends Block> display) {
            return this.blockstateproperty(c, b, matchState, display, "");
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends Block> b, String matchState, Supplier<? extends Block> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstblockstatepropertyate");
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b.get()).toString() + matchState);
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)display.get()).toString() + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder display(char c, Supplier<? extends Block> display) {
            return this.display(c, display, "");
        }

        public DenseMultiblockBuilder display(char c, Supplier<? extends Block> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:display");
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)display.get()).toString() + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder tag(char c, TagKey<Block> tag, Supplier<? extends Block> display) {
            return this.tag(c, tag, "", display, "");
        }

        public DenseMultiblockBuilder tag(char c, TagKey<Block> tag, String matchState, Supplier<? extends Block> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:tag");
            json.addProperty("tag", "#" + tag.f_203868_() + matchState);
            json.addProperty("display", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)display.get()).toString() + displayState);
            return this.map(String.valueOf(c), json);
        }

        @Override
        public JsonObject build() {
            return this.build(true);
        }

        @Override
        public JsonObject build(boolean displayGroundLayer) {
            return this.build(displayGroundLayer, 1);
        }

        @Override
        public JsonObject build(boolean displayGroundLayer, int groundLayerPadding) {
            if (displayGroundLayer) {
                int i;
                this.display('*', () -> Blocks.f_50137_).display('+', () -> Blocks.f_50069_);
                JsonArray pattern = this.multiblock.getAsJsonArray("pattern");
                int width = pattern.get(0).getAsJsonArray().get(0).getAsString().length();
                int length = pattern.get(0).getAsJsonArray().size();
                JsonArray groundLayer = new JsonArray();
                for (i = 0; i < length + groundLayerPadding * 2; ++i) {
                    StringBuilder row = new StringBuilder();
                    for (int j = 0; j < width + groundLayerPadding * 2; ++j) {
                        if ((i + j) % 2 == 0) {
                            row.append("*");
                            continue;
                        }
                        row.append("+");
                    }
                    groundLayer.add(row.toString());
                }
                for (i = 0; i < pattern.size(); ++i) {
                    int j;
                    JsonArray layer = pattern.get(i).getAsJsonArray();
                    for (int j2 = 0; j2 < layer.size(); ++j2) {
                        int k;
                        String row = layer.get(j2).getAsString();
                        StringBuilder newRow = new StringBuilder();
                        for (k = 0; k < groundLayerPadding; ++k) {
                            newRow.append("_");
                        }
                        newRow.append(row);
                        for (k = 0; k < groundLayerPadding; ++k) {
                            newRow.append("_");
                        }
                        layer.set(j2, (JsonElement)new JsonPrimitive(newRow.toString()));
                    }
                    String emptyRow = "_".repeat(length + groundLayerPadding * 2);
                    JsonArray updatedLayer = new JsonArray();
                    for (j = 0; j < groundLayerPadding; ++j) {
                        updatedLayer.add((JsonElement)new JsonPrimitive(emptyRow));
                    }
                    updatedLayer.addAll(layer);
                    for (j = 0; j < groundLayerPadding; ++j) {
                        updatedLayer.add((JsonElement)new JsonPrimitive(emptyRow));
                    }
                    pattern.set(i, (JsonElement)updatedLayer);
                }
                pattern.add((JsonElement)groundLayer);
            }
            return this.multiblock;
        }
    }
}

