/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookCategory {
    protected ResourceLocation id;
    protected Book book;
    protected String name;
    protected BookIcon icon;
    protected int sortNumber;
    protected ResourceLocation background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers;
    protected ResourceLocation entryTextures;
    protected ConcurrentMap<ResourceLocation, BookEntry> entries;
    protected BookCondition condition;
    protected boolean showCategoryButton;

    public BookCategory(ResourceLocation id, String name, int sortNumber, BookCondition condition, boolean showCategoryButton, BookIcon icon, ResourceLocation background, int backgroundWidth, int backgroundHeight, List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers, ResourceLocation entryTextures) {
        this.id = id;
        this.name = name;
        this.sortNumber = sortNumber;
        this.condition = condition;
        this.showCategoryButton = showCategoryButton;
        this.icon = icon;
        this.background = background;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        this.backgroundParallaxLayers = backgroundParallaxLayers;
        this.entryTextures = entryTextures;
        this.entries = new ConcurrentHashMap<ResourceLocation, BookEntry>();
    }

    public static BookCategory fromJson(ResourceLocation id, JsonObject json) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        int sortNumber = GsonHelper.m_13824_((JsonObject)json, (String)"sort_number", (int)-1);
        BookIcon icon = BookIcon.fromString(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"icon")));
        ResourceLocation background = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"background", (String)ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND));
        int backgroundWidth = GsonHelper.m_13824_((JsonObject)json, (String)"background_width", (int)512);
        int backgroundHeight = GsonHelper.m_13824_((JsonObject)json, (String)"background_height", (int)512);
        ResourceLocation entryTextures = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"entry_textures", (String)ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES));
        boolean showCategoryButton = GsonHelper.m_13855_((JsonObject)json, (String)"show_category_button", (boolean)true);
        BookCondition condition = new BookNoneCondition();
        if (json.has("condition")) {
            condition = BookCondition.fromJson(json.getAsJsonObject("condition"));
        }
        List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = List.of();
        if (json.has("background_parallax_layers")) {
            backgroundParallaxLayers = BookCategoryBackgroundParallaxLayer.fromJson(json.getAsJsonArray("background_parallax_layers"));
        }
        return new BookCategory(id, name, sortNumber, condition, showCategoryButton, icon, background, backgroundWidth, backgroundHeight, backgroundParallaxLayers, entryTextures);
    }

    public static BookCategory fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        int sortNumber = buffer.readInt();
        BookIcon icon = BookIcon.fromNetwork(buffer);
        ResourceLocation background = buffer.m_130281_();
        int backgroundWidth = buffer.m_130242_();
        int backgroundHeight = buffer.m_130242_();
        List backgroundParallaxLayers = buffer.m_178366_(BookCategoryBackgroundParallaxLayer::fromNetwork);
        ResourceLocation entryTextures = buffer.m_130281_();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        boolean showCategoryButton = buffer.readBoolean();
        return new BookCategory(id, name, sortNumber, condition, showCategoryButton, icon, background, backgroundWidth, backgroundHeight, backgroundParallaxLayers, entryTextures);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeInt(this.sortNumber);
        this.icon.toNetwork(buffer);
        buffer.m_130085_(this.background);
        buffer.m_130130_(this.backgroundWidth);
        buffer.m_130130_(this.backgroundHeight);
        buffer.m_178352_(this.backgroundParallaxLayers, (buf, layer) -> layer.toNetwork((FriendlyByteBuf)buf));
        buffer.m_130085_(this.entryTextures);
        BookCondition.toNetwork(this.condition, buffer);
        buffer.writeBoolean(this.showCategoryButton);
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }

    public void build(Book book) {
        this.book = book;
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            entry.build(this);
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            entry.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getName() {
        return this.name;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public ResourceLocation getEntryTextures() {
        return this.entryTextures;
    }

    public Map<ResourceLocation, BookEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.id, entry);
    }

    public BookEntry getEntry(ResourceLocation id) {
        return (BookEntry)this.entries.get(id);
    }

    public BookCondition getCondition() {
        return this.condition;
    }
}

