/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BookCommand {
    protected ResourceLocation id;
    protected Book book;
    protected String command;
    protected int permissionLevel;
    protected int maxUses;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;

    public BookCommand(ResourceLocation id, String command, int permissionLevel, int maxUses, @Nullable String failureMessage, @Nullable String successMessage) {
        this.id = id;
        this.command = command;
        this.permissionLevel = permissionLevel;
        this.maxUses = maxUses;
        this.failureMessage = failureMessage;
        this.successMessage = successMessage;
    }

    public static BookCommand fromJson(ResourceLocation id, JsonObject json) {
        String command = GsonHelper.m_13906_((JsonObject)json, (String)"command");
        int permissionLevel = GsonHelper.m_13824_((JsonObject)json, (String)"permission_level", (int)0);
        int maxUses = GsonHelper.m_13824_((JsonObject)json, (String)"max_uses", (int)1);
        String failureMessage = GsonHelper.m_13851_((JsonObject)json, (String)"failure_message", null);
        String successMessage = GsonHelper.m_13851_((JsonObject)json, (String)"success_message", null);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public static BookCommand fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String command = buffer.m_130277_();
        byte permissionLevel = buffer.readByte();
        int maxUses = buffer.m_130242_();
        String failureMessage = buffer.m_182698_(FriendlyByteBuf::m_130277_).orElse(null);
        String successMessage = buffer.m_182698_(FriendlyByteBuf::m_130277_).orElse(null);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public void build(Book book) {
        this.book = book;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.command);
        buffer.writeByte(this.permissionLevel);
        buffer.m_130130_(this.maxUses);
        buffer.m_182687_(Optional.ofNullable(this.failureMessage), FriendlyByteBuf::m_130070_);
        buffer.m_182687_(Optional.ofNullable(this.successMessage), FriendlyByteBuf::m_130070_);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void execute(ServerPlayer player) {
        if (!BookUnlockCapability.canRunFor((Player)player, this)) {
            String failureMessage = this.failureMessage == null ? "modonomicon.command.failure" : this.failureMessage;
            player.m_6352_((Component)new TranslatableComponent(failureMessage).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        CommandSourceStack commandSourceStack = new CommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_183503_(), this.permissionLevel, player.m_7755_().getString(), player.m_5446_(), player.f_8924_, (Entity)player);
        BookUnlockCapability.setRunFor((Player)player, this);
        try {
            player.f_8924_.m_129892_().m_82117_(commandSourceStack, this.command);
            if (this.successMessage != null) {
                player.m_6352_((Component)new TranslatableComponent(this.successMessage).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            }
        }
        catch (Exception e) {
            Modonomicon.LOGGER.error("Running command [" + this.id.toString() + "] failed: ", (Throwable)e);
        }
        BookUnlockCapability.syncFor(player);
    }
}

