/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class BookTextHolder {
    public static final BookTextHolder EMPTY = new BookTextHolder("");
    private Component component;
    private String string;

    protected BookTextHolder() {
    }

    public BookTextHolder(Component component) {
        this.component = component;
    }

    public BookTextHolder(@NotNull String string) {
        this.string = string;
    }

    public static BookTextHolder fromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new BookTextHolder(buffer.m_130238_());
        }
        return new BookTextHolder(buffer.m_130277_());
    }

    public String getString() {
        return this.hasComponent() ? this.component.getString() : I18n.m_118938_((String)this.string, (Object[])new Object[0]);
    }

    public String getKey() {
        Component component;
        if (this.hasComponent() && (component = this.component) instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            return translatableComponent.m_131328_();
        }
        return this.string;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public boolean isEmpty() {
        return (this.hasComponent() ? this.component.getString() : this.string).isEmpty();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hasComponent());
        if (this.hasComponent()) {
            buffer.m_130083_(this.component);
        } else {
            buffer.m_130070_(this.string);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookTextHolder that = (BookTextHolder)o;
        if (this.hasComponent() && that.hasComponent()) {
            return this.component.equals(that.component);
        }
        if (this.string != null) {
            return this.string.equals(that.string);
        }
        return false;
    }
}

