/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookImagePage
extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected ResourceLocation[] images;
    protected boolean border;

    public BookImagePage(BookTextHolder title, BookTextHolder text, ResourceLocation[] images, boolean border, String anchor) {
        super(anchor);
        this.title = title;
        this.text = text;
        this.images = images;
        this.border = border;
    }

    public static BookImagePage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        JsonArray imagesArray = GsonHelper.m_13933_((JsonObject)json, (String)"images");
        ResourceLocation[] images = new ResourceLocation[imagesArray.size()];
        for (int i = 0; i < imagesArray.size(); ++i) {
            images[i] = new ResourceLocation(GsonHelper.m_13805_((JsonElement)imagesArray.get(i), (String)("images[" + i + "]")));
        }
        boolean border = GsonHelper.m_13855_((JsonObject)json, (String)"border", (boolean)true);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        return new BookImagePage(title, text, images, border, anchor);
    }

    public static BookImagePage fromNetwork(FriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        int count = buffer.m_130242_();
        ResourceLocation[] images = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            images[i] = new ResourceLocation(buffer.m_130277_());
        }
        boolean border = buffer.readBoolean();
        String anchor = buffer.m_130277_();
        return new BookImagePage(title, text, images, border, anchor);
    }

    public ResourceLocation[] getImages() {
        return this.images;
    }

    public boolean hasBorder() {
        return this.border;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.IMAGE;
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((Component)new TranslatableComponent(this.title.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        this.title.toNetwork(buffer);
        this.text.toNetwork(buffer);
        buffer.m_130130_(this.images.length);
        for (ResourceLocation image : this.images) {
            buffer.m_130070_(image.toString());
        }
        buffer.writeBoolean(this.border);
        buffer.m_130070_(this.anchor);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

