/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookMultiblockPage
extends BookPage {
    protected BookTextHolder multiblockName;
    protected BookTextHolder text;
    protected boolean showVisualizeButton;
    protected ResourceLocation multiblockId;
    protected Multiblock multiblock;

    public BookMultiblockPage(BookTextHolder multiblockName, BookTextHolder text, ResourceLocation multiblockId, boolean showVisualizeButton, String anchor) {
        super(anchor);
        this.multiblockName = multiblockName;
        this.text = text;
        this.multiblockId = multiblockId;
        this.showVisualizeButton = showVisualizeButton;
    }

    public static BookMultiblockPage fromJson(JsonObject json) {
        BookTextHolder multiblockName = BookGsonHelper.getAsBookTextHolder(json, "multiblock_name", BookTextHolder.EMPTY);
        ResourceLocation multiblockId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"multiblock_id"));
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        boolean showVisualizeButton = GsonHelper.m_13855_((JsonObject)json, (String)"show_visualize_button", (boolean)true);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor);
    }

    public static BookMultiblockPage fromNetwork(FriendlyByteBuf buffer) {
        BookTextHolder multiblockName = BookTextHolder.fromNetwork(buffer);
        ResourceLocation multiblockId = buffer.m_130281_();
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        boolean showVisualizeButton = buffer.readBoolean();
        String anchor = buffer.m_130277_();
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor);
    }

    public boolean showVisualizeButton() {
        return this.showVisualizeButton;
    }

    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    public BookTextHolder getMultiblockName() {
        return this.multiblockName;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.MULTIBLOCK;
    }

    @Override
    public void build(BookEntry parentEntry, int pageNum) {
        super.build(parentEntry, pageNum);
        this.multiblock = MultiblockDataManager.get().getMultiblock(this.multiblockId);
        if (this.multiblock == null) {
            throw new IllegalArgumentException("Invalid multiblock id " + this.multiblockId);
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.multiblockName.hasComponent()) {
            this.multiblockName = new BookTextHolder((Component)new TranslatableComponent(this.multiblockName.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        this.multiblockName.toNetwork(buffer);
        buffer.m_130085_(this.multiblockId);
        this.text.toNetwork(buffer);
        buffer.writeBoolean(this.showVisualizeButton);
        buffer.m_130070_(this.anchor);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.multiblockName.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

