/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class BookRecipePage<T extends Recipe<?>>
extends BookPage {
    protected final RecipeType<? extends T> recipeType;
    protected BookTextHolder title1;
    protected ResourceLocation recipeId1;
    protected T recipe1;
    protected BookTextHolder title2;
    protected ResourceLocation recipeId2;
    protected T recipe2;
    protected BookTextHolder text;

    public BookRecipePage(RecipeType<? extends T> recipeType, BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text, String anchor) {
        super(anchor);
        this.recipeType = recipeType;
        this.title1 = title1;
        this.recipeId1 = recipeId1;
        this.title2 = title2;
        this.recipeId2 = recipeId2;
        this.text = text;
    }

    public static DataHolder commonFromJson(JsonObject json) {
        BookTextHolder title1 = BookGsonHelper.getAsBookTextHolder(json, "title1", BookTextHolder.EMPTY);
        ResourceLocation recipeId1 = json.has("recipe_id_1") ? ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"recipe_id_1")) : null;
        BookTextHolder title2 = BookGsonHelper.getAsBookTextHolder(json, "title2", BookTextHolder.EMPTY);
        ResourceLocation recipeId2 = json.has("recipe_id_2") ? ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"recipe_id_2")) : null;
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        return new DataHolder(title1, recipeId1, title2, recipeId2, text);
    }

    public static DataHolder commonFromNetwork(FriendlyByteBuf buffer) {
        BookTextHolder title1 = BookTextHolder.fromNetwork(buffer);
        ResourceLocation recipeId1 = buffer.readBoolean() ? buffer.m_130281_() : null;
        BookTextHolder title2 = BookTextHolder.fromNetwork(buffer);
        ResourceLocation recipeId2 = buffer.readBoolean() ? buffer.m_130281_() : null;
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        return new DataHolder(title1, recipeId1, title2, recipeId2, text);
    }

    public RecipeType<? extends T> getRecipeType() {
        return this.recipeType;
    }

    public BookTextHolder getTitle1() {
        return this.title1;
    }

    public ResourceLocation getRecipeId1() {
        return this.recipeId1;
    }

    public T getRecipe1() {
        return this.recipe1;
    }

    public BookTextHolder getTitle2() {
        return this.title2;
    }

    public ResourceLocation getRecipeId2() {
        return this.recipeId2;
    }

    public T getRecipe2() {
        return this.recipe2;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    protected T loadRecipe(BookEntry entry, ResourceLocation recipeId) {
        if (recipeId == null) {
            return null;
        }
        T tempRecipe = this.getRecipe(recipeId);
        if (tempRecipe == null) {
            Modonomicon.LOGGER.warn("Recipe {} (of type {}) not found.", (Object)recipeId, (Object)Registry.f_122864_.m_7981_(this.recipeType));
        }
        return tempRecipe;
    }

    protected abstract ItemStack getRecipeOutput(T var1);

    private T getRecipe(ResourceLocation id) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        RecipeManager manager = server != null ? server.m_129894_() : Minecraft.m_91087_().f_91073_.m_7465_();
        return (T)((Recipe)manager.m_44043_(id).filter(recipe -> recipe.m_6671_() == this.recipeType).orElse(null));
    }

    @Override
    public void build(BookEntry parentEntry, int pageNum) {
        super.build(parentEntry, pageNum);
        this.recipe1 = this.loadRecipe(parentEntry, this.recipeId1);
        this.recipe2 = this.loadRecipe(parentEntry, this.recipeId2);
        if (this.recipe1 == null && this.recipe2 != null) {
            this.recipe1 = this.recipe2;
            this.recipe2 = null;
        }
        if (this.title1.isEmpty()) {
            this.title1 = new BookTextHolder((Component)((MutableComponent)this.getRecipeOutput(this.recipe1).m_41786_()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.recipe2 != null && this.title2.isEmpty()) {
            this.title2 = new BookTextHolder((Component)((MutableComponent)this.getRecipeOutput(this.recipe2).m_41786_()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.title1.equals(this.title2)) {
            this.title2 = BookTextHolder.EMPTY;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title1.hasComponent()) {
            this.title1 = new BookTextHolder((Component)new TranslatableComponent(this.title1.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.title2.hasComponent()) {
            this.title2 = new BookTextHolder((Component)new TranslatableComponent(this.title2.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        this.title1.toNetwork(buffer);
        buffer.writeBoolean(this.recipeId1 != null);
        if (this.recipeId1 != null) {
            buffer.m_130085_(this.recipeId1);
        }
        this.title2.toNetwork(buffer);
        buffer.writeBoolean(this.recipeId2 != null);
        if (this.recipeId2 != null) {
            buffer.m_130085_(this.recipeId2);
        }
        this.text.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title1.getString().toLowerCase().contains(query) || this.title2.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }

    public record DataHolder(BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text) {
    }
}

