/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.capability;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryUnlockedCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionCategoryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.integration.ModonomiconKubeJSIntegration;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.SyncBookUnlockCapabilityMessage;
import com.klikli_dev.modonomicon.registry.CapabilityRegistry;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.AdvancementEvent;

public class BookUnlockCapability
implements INBTSerializable<CompoundTag> {
    protected final Player player;
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> readEntries = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedEntries = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedCategories = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
    public ConcurrentMap<ResourceLocation, Map<ResourceLocation, Integer>> usedCommands = new ConcurrentHashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public BookUnlockCapability(Player player) {
        this.player = player;
    }

    public static String getUnlockCodeFor(Player player, Book book) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.getUnlockCode(book)).orElse("No unlocked content.");
    }

    public static Book applyUnlockCodeFor(ServerPlayer player, String unlockCode) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> {
            Book book = c.applyUnlockCode(unlockCode);
            if (book != null) {
                c.sync(player);
            }
            return book;
        }).orElse(null);
    }

    public static void syncFor(ServerPlayer player) {
        player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(c -> c.sync(player));
    }

    public static void updateAndSyncFor(final ServerPlayer player) {
        if (BookDataManager.get().areBooksBuilt()) {
            player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(capability -> {
                capability.update(player);
                capability.sync(player);
            });
        } else {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    player.f_8924_.execute(() -> BookUnlockCapability.updateAndSyncFor(player));
                }
            }, 1000L);
        }
    }

    public static List<ResourceLocation> getBooksFor(Player player) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.getBooks()).orElse(Collections.emptyList());
    }

    public static void resetFor(Player player, Book book) {
        player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(c -> c.reset(book));
    }

    public static boolean isUnlockedFor(Player player, BookCategory category) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.isUnlocked(category)).orElse(false);
    }

    public static boolean isUnlockedFor(Player player, BookEntry entry) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.isUnlocked(entry)).orElse(false);
    }

    public static boolean isReadFor(Player player, BookEntry entry) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.isRead(entry)).orElse(false);
    }

    public static boolean canRunFor(Player player, BookCommand command) {
        return player.getCapability(CapabilityRegistry.BOOK_UNLOCK).map(c -> c.canRun(command)).orElse(false);
    }

    public static void setRunFor(Player player, BookCommand command) {
        player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(c -> c.setRun(command));
    }

    public static void onAdvancement(AdvancementEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            BookUnlockCapability.updateAndSyncFor(serverplayer);
        }
    }

    public void clone(BookUnlockCapability other) {
        this.unlockedEntries = other.unlockedEntries;
        this.unlockedCategories = other.unlockedCategories;
        this.readEntries = other.readEntries;
        this.usedCommands = other.usedCommands;
    }

    public void update(ServerPlayer owner) {
        boolean unlockedAny;
        BookConditionContext categoryContext;
        ArrayList<Map.Entry<BookEntryUnlockedCondition, BookConditionContext>> unlockedConditions = new ArrayList<Map.Entry<BookEntryUnlockedCondition, BookConditionContext>>();
        HashSet<BookConditionContext> newlyUnlockedContent = new HashSet<BookConditionContext>();
        for (Book book : BookDataManager.get().getBooks().values()) {
            BookErrorManager.get().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            for (BookCategory category : book.getCategories().values()) {
                BookErrorManager.get().setContext("Category to perform condition test on: {}", category.getId().toString());
                try {
                    categoryContext = BookConditionContext.of(book, category);
                    if (category.getCondition().test(categoryContext, (Player)owner)) {
                        set = this.unlockedCategories.computeIfAbsent(book.getId(), k -> new HashSet());
                        if (!set.contains(category.getId())) {
                            set.add(category.getId());
                            newlyUnlockedContent.add(categoryContext);
                        }
                    } else {
                        set = category.getCondition();
                        if (set instanceof BookEntryUnlockedCondition) {
                            BookEntryUnlockedCondition bookEntryUnlockedCondition = (BookEntryUnlockedCondition)set;
                            unlockedConditions.add(Map.entry(bookEntryUnlockedCondition, categoryContext));
                        }
                    }
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing category condition", e);
                }
                for (BookEntry bookEntry : category.getEntries().values()) {
                    BookErrorManager.get().setContext("Entry to perform condition test on: {}", bookEntry.getId().toString());
                    try {
                        BookConditionContext entryContext = BookConditionContext.of(book, bookEntry);
                        if (bookEntry.getCondition().test(entryContext, (Player)owner)) {
                            Set set = this.unlockedEntries.computeIfAbsent(book.getId(), k -> new HashSet());
                            if (set.contains(bookEntry.getId())) continue;
                            set.add(bookEntry.getId());
                            newlyUnlockedContent.add(entryContext);
                            continue;
                        }
                        BookCondition bookCondition = bookEntry.getCondition();
                        if (!(bookCondition instanceof BookEntryUnlockedCondition)) continue;
                        BookEntryUnlockedCondition bookEntryUnlockedCondition = (BookEntryUnlockedCondition)bookCondition;
                        unlockedConditions.add(Map.entry(bookEntryUnlockedCondition, entryContext));
                    }
                    catch (Exception e) {
                        BookErrorManager.get().error("Error while testing entry condition", e);
                    }
                }
            }
        }
        BookErrorManager.get().reset();
        do {
            unlockedAny = false;
            Iterator iter = unlockedConditions.iterator();
            while (iter.hasNext()) {
                Map.Entry condition = (Map.Entry)iter.next();
                BookErrorManager.get().setCurrentBookId(((BookConditionContext)condition.getValue()).getBook().getId());
                BookErrorManager.get().setContext("Context to perform unlockedConditions test on: {}", ((BookConditionContext)condition.getValue()).toString());
                if (!((BookEntryUnlockedCondition)condition.getKey()).test((BookConditionContext)condition.getValue(), (Player)owner)) continue;
                try {
                    Object v = condition.getValue();
                    if (v instanceof BookConditionEntryContext) {
                        BookConditionEntryContext entryContext = (BookConditionEntryContext)v;
                        Set set = this.unlockedEntries.computeIfAbsent(entryContext.getBook().getId(), k -> new HashSet());
                        if (!set.contains(entryContext.getEntry().getId())) {
                            set.add(entryContext.getEntry().getId());
                            newlyUnlockedContent.add(entryContext);
                        }
                    } else {
                        Set set;
                        Object v2 = condition.getValue();
                        if (v2 instanceof BookConditionCategoryContext && !(set = this.unlockedCategories.computeIfAbsent((categoryContext = (BookConditionCategoryContext)v2).getBook().getId(), k -> new HashSet())).contains(((BookConditionCategoryContext)categoryContext).getCategory().getId())) {
                            set.add(((BookConditionCategoryContext)categoryContext).getCategory().getId());
                            newlyUnlockedContent.add(categoryContext);
                        }
                    }
                    unlockedAny = true;
                    iter.remove();
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing entry condition", e);
                }
            }
        } while (unlockedAny);
        BookErrorManager.get().reset();
        this.notifyNewlyUnlockedContent(owner, newlyUnlockedContent);
    }

    public void notifyNewlyUnlockedContent(ServerPlayer player, Set<BookConditionContext> newlyUnlockedContent) {
        ModonomiconKubeJSIntegration.postNewContentUnlockedEvent(player, newlyUnlockedContent);
    }

    public void sync(ServerPlayer player) {
        Networking.sendTo(player, new SyncBookUnlockCapabilityMessage(this));
    }

    public boolean read(ServerPlayer player, BookEntry entry) {
        Player player2;
        if (this.isRead(entry)) {
            return false;
        }
        this.readEntries.computeIfAbsent(entry.getBook().getId(), k -> new HashSet()).add(entry.getId());
        BookCommand command = entry.getCommandToRunOnFirstRead();
        if (command != null && (player2 = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            command.execute(serverPlayer);
        }
        ModonomiconKubeJSIntegration.postEntryReadEvent(player, entry);
        return true;
    }

    public void setRun(BookCommand command) {
        if (command.getBook() == null) {
            return;
        }
        Integer uses = ((Map)this.usedCommands.getOrDefault(command.getBook().getId(), new HashMap())).getOrDefault(command.getId(), 0);
        this.usedCommands.computeIfAbsent(command.getBook().getId(), k -> new HashMap()).put(command.getId(), uses + 1);
    }

    public boolean canRun(BookCommand command) {
        if (command.getBook() == null) {
            return false;
        }
        if (command.getMaxUses() == -1) {
            return true;
        }
        return ((Map)this.usedCommands.getOrDefault(command.getBook().getId(), new HashMap())).getOrDefault(command.getId(), 0) < command.getMaxUses();
    }

    public boolean isRead(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return ((Set)this.readEntries.getOrDefault(entry.getBook().getId(), new HashSet())).contains(entry.getId());
    }

    public boolean isUnlocked(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return ((Set)this.unlockedEntries.getOrDefault(entry.getBook().getId(), new HashSet())).contains(entry.getId());
    }

    public boolean isUnlocked(BookCategory category) {
        if (category.getBook() == null) {
            return false;
        }
        return ((Set)this.unlockedCategories.getOrDefault(category.getBook().getId(), new HashSet())).contains(category.getId());
    }

    public void reset(Book book) {
        this.readEntries.remove(book.getId());
        this.unlockedEntries.remove(book.getId());
        this.unlockedCategories.remove(book.getId());
    }

    public List<ResourceLocation> getBooks() {
        HashSet books = new HashSet();
        books.addAll(this.readEntries.keySet());
        books.addAll(this.unlockedEntries.keySet());
        books.addAll(this.unlockedCategories.keySet());
        return books.stream().toList();
    }

    public String getUnlockCode(Book book) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(book.getId());
        Set unlockedCategories = this.unlockedCategories.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(unlockedCategories.size());
        unlockedCategories.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        Set unlockedEntries = this.unlockedEntries.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(unlockedEntries.size());
        unlockedEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        Set readEntries = this.readEntries.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(readEntries.size());
        readEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Book applyUnlockCode(String code) {
        try {
            byte[] decoded = Base64.getDecoder().decode(code);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decoded));
            ResourceLocation bookId = buf.m_130281_();
            Book book = BookDataManager.get().getBook(bookId);
            if (book == null) {
                return null;
            }
            HashSet<ResourceLocation> unlockedCategories = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> unlockedEntries = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> readEntries = new HashSet<ResourceLocation>();
            int unlockedCategoriesSize = buf.m_130242_();
            for (int i = 0; i < unlockedCategoriesSize; ++i) {
                unlockedCategories.add(buf.m_130281_());
            }
            int unlockedEntriesSize = buf.m_130242_();
            for (int i = 0; i < unlockedEntriesSize; ++i) {
                unlockedEntries.add(buf.m_130281_());
            }
            int readEntriesSize = buf.m_130242_();
            for (int i = 0; i < readEntriesSize; ++i) {
                readEntries.add(buf.m_130281_());
            }
            this.unlockedCategories.put(bookId, unlockedCategories);
            this.unlockedEntries.put(bookId, unlockedEntries);
            this.readEntries.put(bookId, readEntries);
            return book;
        }
        catch (Exception e) {
            return null;
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("modonomicon:nbt_version", "1.0.0");
        ListTag unlockedCategoriesByBook = new ListTag();
        compound.m_128365_("unlocked_categories", (Tag)unlockedCategoriesByBook);
        this.unlockedCategories.forEach((bookId, categories) -> {
            CompoundTag bookCompound = new CompoundTag();
            ListTag unlockedCategoriesList = new ListTag();
            bookCompound.m_128359_("book_id", bookId.toString());
            bookCompound.m_128365_("unlocked_categories", (Tag)unlockedCategoriesList);
            categories.forEach(categoryId -> {
                CompoundTag categoryCompound = new CompoundTag();
                categoryCompound.m_128359_("category_id", categoryId.toString());
                unlockedCategoriesList.add((Object)categoryCompound);
            });
            unlockedCategoriesByBook.add((Object)bookCompound);
        });
        ListTag unlockedEntriesByBook = new ListTag();
        compound.m_128365_("unlocked_entries", (Tag)unlockedEntriesByBook);
        this.unlockedEntries.forEach((bookId, entries) -> {
            CompoundTag bookCompound = new CompoundTag();
            ListTag unlockedEntriesList = new ListTag();
            bookCompound.m_128359_("book_id", bookId.toString());
            bookCompound.m_128365_("unlocked_entries", (Tag)unlockedEntriesList);
            entries.forEach(entryId -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128359_("entry_id", entryId.toString());
                unlockedEntriesList.add((Object)entryCompound);
            });
            unlockedEntriesByBook.add((Object)bookCompound);
        });
        ListTag readEntriesByBook = new ListTag();
        compound.m_128365_("read_entries", (Tag)readEntriesByBook);
        this.readEntries.forEach((bookId, entries) -> {
            CompoundTag bookCompound = new CompoundTag();
            ListTag readEntriesList = new ListTag();
            bookCompound.m_128359_("book_id", bookId.toString());
            bookCompound.m_128365_("read_entries", (Tag)readEntriesList);
            entries.forEach(entryId -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128359_("entry_id", entryId.toString());
                readEntriesList.add((Object)entryCompound);
            });
            readEntriesByBook.add((Object)bookCompound);
        });
        ListTag usedCommandsByBook = new ListTag();
        compound.m_128365_("used_commands", (Tag)usedCommandsByBook);
        this.usedCommands.forEach((bookId, commands) -> {
            CompoundTag bookCompound = new CompoundTag();
            ListTag usedCommandsList = new ListTag();
            bookCompound.m_128359_("book_id", bookId.toString());
            bookCompound.m_128365_("used_commands", (Tag)usedCommandsList);
            commands.forEach((command, used) -> {
                CompoundTag commandCompound = new CompoundTag();
                commandCompound.m_128359_("command", command.toString());
                commandCompound.m_128405_("used", used.intValue());
                usedCommandsList.add((Object)commandCompound);
            });
            usedCommandsByBook.add((Object)bookCompound);
        });
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.unlockedCategories.clear();
        ListTag unlockedCategoriesByBook = nbt.m_128437_("unlocked_categories", 10);
        for (Object bookEntry : unlockedCategoriesByBook) {
            if (!(bookEntry instanceof CompoundTag)) continue;
            CompoundTag bookCompound = (CompoundTag)bookEntry;
            ResourceLocation bookId = ResourceLocation.m_135820_((String)bookCompound.m_128461_("book_id"));
            ListTag unlockedCategoriesList = bookCompound.m_128437_("unlocked_categories", 10);
            HashSet<ResourceLocation> categories = new HashSet<ResourceLocation>();
            for (Object categoryEntry : unlockedCategoriesList) {
                if (!(categoryEntry instanceof CompoundTag)) continue;
                CompoundTag categoryCompound = (CompoundTag)categoryEntry;
                ResourceLocation categoryId = ResourceLocation.m_135820_((String)categoryCompound.m_128461_("category_id"));
                categories.add(categoryId);
            }
            this.unlockedCategories.put(bookId, categories);
        }
        this.unlockedEntries.clear();
        ListTag unlockedEntriesByBook = nbt.m_128437_("unlocked_entries", 10);
        for (Object bookEntry : unlockedEntriesByBook) {
            if (!(bookEntry instanceof CompoundTag)) continue;
            CompoundTag bookCompound = (CompoundTag)bookEntry;
            ResourceLocation bookId = ResourceLocation.m_135820_((String)bookCompound.m_128461_("book_id"));
            ListTag unlockedEntriesList = bookCompound.m_128437_("unlocked_entries", 10);
            HashSet<ResourceLocation> entries = new HashSet<ResourceLocation>();
            for (Object entry : unlockedEntriesList) {
                if (!(entry instanceof CompoundTag)) continue;
                CompoundTag pageCompound = (CompoundTag)entry;
                ResourceLocation entryId = ResourceLocation.m_135820_((String)pageCompound.m_128461_("entry_id"));
                entries.add(entryId);
            }
            this.unlockedEntries.put(bookId, entries);
        }
        this.readEntries.clear();
        ListTag readEntriesByBook = nbt.m_128437_("read_entries", 10);
        for (Tag bookEntry : readEntriesByBook) {
            if (!(bookEntry instanceof CompoundTag)) continue;
            CompoundTag bookCompound = (CompoundTag)bookEntry;
            ResourceLocation bookId = ResourceLocation.m_135820_((String)bookCompound.m_128461_("book_id"));
            ListTag readEntriesList = bookCompound.m_128437_("read_entries", 10);
            HashSet<ResourceLocation> entries = new HashSet<ResourceLocation>();
            for (Tag entry : readEntriesList) {
                if (!(entry instanceof CompoundTag)) continue;
                CompoundTag pageCompound = (CompoundTag)entry;
                ResourceLocation entryId = ResourceLocation.m_135820_((String)pageCompound.m_128461_("entry_id"));
                entries.add(entryId);
            }
            this.readEntries.put(bookId, entries);
        }
        this.usedCommands.clear();
        ListTag usedCommandsByBook = nbt.m_128437_("used_commands", 10);
        for (Tag usedCommand : usedCommandsByBook) {
            if (!(usedCommand instanceof CompoundTag)) continue;
            CompoundTag bookCompound = (CompoundTag)usedCommand;
            ResourceLocation bookId = ResourceLocation.m_135820_((String)bookCompound.m_128461_("book_id"));
            ListTag usedCommandsList = bookCompound.m_128437_("used_commands", 10);
            HashMap<ResourceLocation, Integer> commands = new HashMap<ResourceLocation, Integer>();
            for (Tag command : usedCommandsList) {
                if (!(command instanceof CompoundTag)) continue;
                CompoundTag commandCompound = (CompoundTag)command;
                ResourceLocation commandId = ResourceLocation.m_135820_((String)commandCompound.m_128461_("command"));
                int used = commandCompound.m_128451_("used");
                commands.put(commandId, used);
            }
            this.usedCommands.put(bookId, commands);
        }
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundTag> {
        private final BookUnlockCapability bookUnlockCapability;
        private final LazyOptional<BookUnlockCapability> bookUnlockCapabilityLazy;

        public Dispatcher(Player player) {
            this.bookUnlockCapability = new BookUnlockCapability(player);
            this.bookUnlockCapabilityLazy = LazyOptional.of(() -> this.bookUnlockCapability);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityRegistry.BOOK_UNLOCK) {
                return this.bookUnlockCapabilityLazy.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.bookUnlockCapability.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.bookUnlockCapability.deserializeNBT(nbt);
        }
    }
}

