/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.client.BookBakedModel;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientSetupEventHandler {
    public static void onClientSetup(FMLClientSetupEvent event) {
        PageRendererRegistry.registerPageRenderers();
        ClientSetupEventHandler.registerItemModelProperties(event);
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                ClientTicks.endClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTicks.renderTickStart(e.renderTickTime);
            } else {
                ClientTicks.renderTickEnd();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                MultiblockPreviewRenderer.onClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                MultiblockPreviewRenderer.onRenderHUD(e.getMatrixStack(), e.getPartialTicks());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(MultiblockPreviewRenderer::onRenderLevelLastEvent);
        event.enqueueWork(() -> Modonomicon.LOGGER.debug("Registered Screen Containers"));
        Modonomicon.LOGGER.info("Client setup complete.");
    }

    public static void registerItemModelProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> Modonomicon.LOGGER.debug("Registered Item Properties"));
    }

    public static void onModelBake(ModelBakeEvent event) {
        ModelResourceLocation key = new ModelResourceLocation(ModonomiconConstants.Data.Book.ITEM_ID, "inventory");
        BakedModel oldModel = (BakedModel)event.getModelRegistry().get(key);
        if (oldModel != null) {
            event.getModelRegistry().put(key, new BookBakedModel(oldModel, (ModelBakery)event.getModelLoader()));
        }
    }
}

