/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.capability.bookstate.EntryState;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookHistoryEntry;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.integration.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.integration.ModonomiconPatchouliIntegration;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.network.messages.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.registry.SoundRegistry;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import com.klikli_dev.modonomicon.util.RenderUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class BookContentScreen
extends Screen
implements BookScreenWithButtons {
    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    public static final int TOP_PADDING = 15;
    public static final int LEFT_PAGE_X = 12;
    public static final int RIGHT_PAGE_X = 141;
    public static final int PAGE_WIDTH = 124;
    public static final int PAGE_HEIGHT = 128;
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int MAX_TITLE_WIDTH = 120;
    public static final int CLICK_SAFETY_MARGIN = 20;
    private static long lastTurnPageSoundTime;
    private final BookOverviewScreen parentScreen;
    private final BookEntry entry;
    private final ResourceLocation bookContentTexture;
    public int ticksInBook;
    public boolean simulateEscClosing;
    private BookPage leftPage;
    private BookPage rightPage;
    private BookPageRenderer<?> leftPageRenderer;
    private BookPageRenderer<?> rightPageRenderer;
    private int bookLeft;
    private int bookTop;
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<Component> tooltip;
    private ItemStack tooltipStack;
    private boolean isHoveringItemLink;

    public BookContentScreen(BookOverviewScreen parentScreen, BookEntry entry) {
        super((Component)new TextComponent(""));
        this.f_96541_ = Minecraft.m_91087_();
        this.parentScreen = parentScreen;
        this.entry = entry;
        this.bookContentTexture = this.parentScreen.getBook().getBookContentTexture();
        this.loadEntryState();
    }

    public static void drawFromTexture(PoseStack poseStack, Book book, int x, int y, int u, int v, int w, int h) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)book.getBookContentTexture());
        BookContentScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public static void drawTitleSeparator(PoseStack poseStack, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        BookContentScreen.drawFromTexture(poseStack, book, rx, y, 0, 253, w, h);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(PoseStack ms, Book book, int x, int y) {
        BookContentScreen.drawFromTexture(ms, book, x, y, 496, 0, 16, 16);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6L) {
            SoundEvent sound = Registry.f_122821_.m_6612_(book.getTurnPageSound()).orElse((SoundEvent)SoundRegistry.TURN_PAGE.get());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)((float)(0.7 + Math.random() * 0.3))));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    @Override
    public Book getBook() {
        return this.entry.getBook();
    }

    public static void renderBookBackground(PoseStack poseStack, ResourceLocation bookContentTexture) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)bookContentTexture);
        int x = 0;
        int y = 0;
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)272, (int)178, (int)512, (int)256);
    }

    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    public boolean canSeeBackButton() {
        return BookGuiManager.get().getHistorySize() > 0;
    }

    public void handleArrowButton(Button button) {
        this.flipPage(((ArrowButton)button).left, true);
    }

    public void handleBackButton(Button button) {
        if (BookGuiManager.get().getHistorySize() > 0) {
            BookHistoryEntry lastPage = BookGuiManager.get().popHistory();
            BookGuiManager.get().openEntry(lastPage.bookId, lastPage.categoryId, lastPage.entryId, lastPage.page);
        }
    }

    public void handleExitButton(Button button) {
        this.m_7379_();
    }

    public void setTooltip(Component ... strings) {
        this.setTooltip(List.of(strings));
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void renderItemStack(PoseStack poseStack, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        RenderUtil.renderAndDecorateItemAndDecorationsWithPose(poseStack, stack, this.f_96547_, x, y);
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderIngredient(PoseStack poseStack, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        ItemStack[] stacks = ingr.m_43908_();
        if (stacks.length > 0) {
            this.renderItemStack(poseStack, x, y, mouseX, mouseY, stacks[this.ticksInBook / 20 % stacks.length]);
        }
    }

    public void goToPage(int pageIndex, boolean playSound) {
        int openPagesIndex = pageIndex / 2;
        if (openPagesIndex >= 0 && openPagesIndex < this.maxOpenPagesIndex) {
            if (this.openPagesIndex != openPagesIndex) {
                this.openPagesIndex = openPagesIndex;
                this.onPageChanged();
                if (playSound) {
                    BookContentScreen.playTurnPageSound(this.getBook());
                }
            }
        } else {
            Modonomicon.LOGGER.warn("Tried to change to page index {} corresponding with openPagesIndex {} but max open pages index is {}.", new Object[]{pageIndex, openPagesIndex, this.maxOpenPagesIndex});
        }
    }

    public Style getClickedComponentStyleAtForPage(BookPageRenderer<?> page, double pMouseX, double pMouseY) {
        if (page != null) {
            return page.getClickedComponentStyleAt(pMouseX - (double)this.bookLeft - (double)page.left, pMouseY - (double)this.bookTop - (double)page.top);
        }
        return null;
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        Style leftPageClickedStyle = this.getClickedComponentStyleAtForPage(this.leftPageRenderer, pMouseX, pMouseY);
        if (leftPageClickedStyle != null) {
            return leftPageClickedStyle;
        }
        Style rightPageClickedStyle = this.getClickedComponentStyleAtForPage(this.rightPageRenderer, pMouseX, pMouseY);
        return rightPageClickedStyle;
    }

    public int getBookLeft() {
        return this.bookLeft;
    }

    public int getBookTop() {
        return this.bookTop;
    }

    public void removeRenderableWidgets(Collection<? extends Widget> widgets) {
        this.f_169369_.removeIf(widgets::contains);
        this.m_6702_().removeIf(c -> c instanceof Widget && widgets.contains(c));
        this.f_169368_.removeIf(n -> n instanceof Widget && widgets.contains(n));
    }

    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            int oldOpenPagesIndex = this.openPagesIndex--;
            if (!left) {
                ++this.openPagesIndex;
            }
            if (BookGuiManager.get().getHistorySize() > 0) {
                BookHistoryEntry lastPage = BookGuiManager.get().peekHistory();
                if (lastPage.bookId == this.entry.getBook().getId() && lastPage.entryId == this.entry.getId() && lastPage.page == this.openPagesIndex * 2) {
                    BookGuiManager.get().popHistory();
                } else {
                    BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), oldOpenPagesIndex * 2);
                }
            } else {
                BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), oldOpenPagesIndex * 2);
            }
            this.onPageChanged();
            if (playSound) {
                BookContentScreen.playTurnPageSound(this.getBook());
            }
        }
    }

    protected void drawTooltip(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        if (this.tooltipStack != null) {
            List<Component> tooltip = this.m_96555_(this.tooltipStack);
            this.m_96597_(pPoseStack, tooltip, pMouseX, pMouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.m_96597_(pPoseStack, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected boolean clickPage(BookPageRenderer<?> page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)this.bookLeft - (double)page.left, mouseY - (double)this.bookTop - (double)page.top, mouseButton);
        }
        return false;
    }

    protected void renderPage(PoseStack poseStack, BookPageRenderer<?> page, int pMouseX, int pMouseY, float pPartialTick) {
        if (page == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)page.left, (double)page.top, 0.0);
        page.render(poseStack, pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top, pPartialTick);
        poseStack.m_85849_();
    }

    protected void beginDisplayPages() {
        if (this.leftPageRenderer != null) {
            this.leftPageRenderer.onEndDisplayPage(this);
        }
        if (this.rightPageRenderer != null) {
            this.rightPageRenderer.onEndDisplayPage(this);
        }
        List<BookPage> pages = this.entry.getPages();
        int leftPageIndex = this.openPagesIndex * 2;
        int rightPageIndex = leftPageIndex + 1;
        this.leftPage = leftPageIndex < pages.size() ? pages.get(leftPageIndex) : null;
        BookPage bookPage = this.rightPage = rightPageIndex < pages.size() ? pages.get(rightPageIndex) : null;
        if (this.leftPage != null) {
            this.leftPageRenderer = PageRendererRegistry.getPageRenderer(this.leftPage.getType()).create(this.leftPage);
            this.leftPageRenderer.onBeginDisplayPage(this, 12, 15);
        } else {
            this.leftPageRenderer = null;
        }
        if (this.rightPage != null) {
            this.rightPageRenderer = PageRendererRegistry.getPageRenderer(this.rightPage.getType()).create(this.rightPage);
            this.rightPageRenderer.onBeginDisplayPage(this, 141, 15);
        } else {
            this.rightPageRenderer = null;
        }
    }

    protected void onPageChanged() {
        this.beginDisplayPages();
    }

    protected void resetTooltip() {
        this.tooltip = null;
        this.tooltipStack = null;
    }

    private boolean clickOutsideEntry(double pMouseX, double pMouseY) {
        return pMouseX < (double)(this.bookLeft - 20) || pMouseX > (double)(this.bookLeft + 272 + 20) || pMouseY < (double)(this.bookTop - 20) || pMouseY > (double)(this.bookTop + 180 + 20);
    }

    private void loadEntryState() {
        EntryState state = BookStateCapability.getEntryStateFor((Player)this.parentScreen.getMinecraft().f_91074_, this.entry);
        BookGuiManager.get().currentEntry = this.entry;
        BookGuiManager.get().currentContentScreen = this;
        if (state != null) {
            this.openPagesIndex = state.openPagesIndex;
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.m_69465_();
        this.resetTooltip();
        int blitOffset = this.m_93252_();
        this.m_93250_(-1300);
        this.m_7333_(pPoseStack);
        this.m_93250_(blitOffset);
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)this.bookLeft, (double)this.bookTop, 0.0);
        BookContentScreen.renderBookBackground(pPoseStack, this.bookContentTexture);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)this.bookLeft, (double)this.bookTop, 0.0);
        this.renderPage(pPoseStack, this.leftPageRenderer, pMouseX, pMouseY, pPartialTick);
        this.renderPage(pPoseStack, this.rightPageRenderer, pMouseX, pMouseY, pPartialTick);
        pPoseStack.m_85849_();
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.drawTooltip(pPoseStack, pMouseX, pMouseY);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        if (this.simulateEscClosing || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            Networking.sendToServer(new SaveEntryStateMessage(this.entry, this.openPagesIndex));
            super.m_7379_();
            this.parentScreen.m_7379_();
            this.simulateEscClosing = false;
        } else {
            Networking.sendToServer(new SaveEntryStateMessage(this.entry, (Boolean)ClientConfig.get().qolCategory.storeLastOpenPageWhenClosingEntry.get() != false ? this.openPagesIndex : 0));
            this.parentScreen.getCurrentCategoryScreen().onCloseEntry(this);
            super.m_7379_();
        }
    }

    public <T extends GuiEventListener & Widget> T m_142416_(T pWidget) {
        return (T)super.m_142416_(pWidget);
    }

    public void m_96570_(PoseStack pPoseStack, @Nullable Style style, int mouseX, int mouseY) {
        ClickEvent clickEvent;
        Style newStyle = style;
        if (style != null && style.m_131186_() != null && style.m_131186_().m_130820_() == HoverEvent.Action.f_130831_ && (clickEvent = style.m_131182_()) != null) {
            MutableComponent newComponent;
            Component oldComponent;
            Book book;
            Object link;
            if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE && BookLink.isBookLink(clickEvent.m_130623_())) {
                BookEntry entry;
                link = BookLink.from(this.getBook(), clickEvent.m_130623_());
                book = BookDataManager.get().getBook(((BookLink)link).bookId);
                if (((BookLink)link).entryId != null && !BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, entry = book.getEntry(((BookLink)link).entryId))) {
                    oldComponent = (Component)style.m_131186_().m_130823_(HoverEvent.Action.f_130831_);
                    newComponent = new TranslatableComponent("modonomicon.gui.hover.book_link_locked", new Object[]{oldComponent, new TranslatableComponent("modonomicon.gui.hover.book_link_locked_info").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16711701)).m_131136_(Boolean.valueOf(true)))});
                    newStyle = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)newComponent));
                }
            }
            if (clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND && CommandLink.isCommandLink(clickEvent.m_130623_())) {
                link = CommandLink.from(this.getBook(), clickEvent.m_130623_());
                book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    oldComponent = (Component)style.m_131186_().m_130823_(HoverEvent.Action.f_130831_);
                    if (!BookUnlockCapability.canRunFor((Player)this.f_96541_.f_91074_, command)) {
                        MutableComponent hoverComponent = new TranslatableComponent("modonomicon.gui.hover.command_link.unavailable").m_130940_(ChatFormatting.RED);
                        newStyle = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent));
                        oldComponent = hoverComponent;
                    }
                    if (BookContentScreen.m_96638_()) {
                        newComponent = oldComponent.m_6881_().m_7220_((Component)new TextComponent("\n")).m_7220_((Component)new TextComponent(command.getCommand()).m_130940_(ChatFormatting.GRAY));
                        newStyle = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)newComponent));
                    }
                }
            }
        }
        if ((style = newStyle) != null && style.m_131186_() != null) {
            HoverEvent hoverevent = style.m_131186_();
            HoverEvent.ItemStackInfo hoverevent$itemstackinfo = (HoverEvent.ItemStackInfo)hoverevent.m_130823_(HoverEvent.Action.f_130832_);
            if (hoverevent$itemstackinfo != null) {
                if (style.m_131182_() != null) {
                    this.isHoveringItemLink = true;
                }
                int backupWidth = this.f_96543_;
                this.f_96543_ /= 2;
                this.m_6057_(pPoseStack, hoverevent$itemstackinfo.m_130898_(), mouseX, mouseY);
                this.f_96543_ = backupWidth;
                this.isHoveringItemLink = false;
            } else {
                HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = (HoverEvent.EntityTooltipInfo)hoverevent.m_130823_(HoverEvent.Action.f_130833_);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.f_96541_.f_91066_.f_92125_) {
                        this.m_96597_(pPoseStack, hoverevent$entitytooltipinfo.m_130884_(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)hoverevent.m_130823_(HoverEvent.Action.f_130831_);
                    if (component != null) {
                        int width = this.f_96543_ / 2 - mouseX - 10;
                        this.m_96617_(pPoseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)component, width), mouseX, mouseY);
                    }
                }
            }
        }
    }

    public List<Component> m_96555_(ItemStack pItemStack) {
        List tooltip = super.m_96555_(pItemStack);
        if (this.isHoveringItemLink) {
            tooltip.add(new TextComponent(""));
            if (ModonomiconJeiIntegration.isJeiLoaded()) {
                tooltip.add(new TranslatableComponent("modonomicon.gui.hover.item_link_info").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN)));
                tooltip.add(new TranslatableComponent("modonomicon.gui.hover.item_link_info_line2").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
            } else {
                tooltip.add(new TranslatableComponent("modonomicon.gui.hover.item_link_info.no_jei").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED)));
            }
        }
        return tooltip;
    }

    public boolean m_5561_(@Nullable Style pStyle) {
        ClickEvent event;
        if (pStyle != null && (event = pStyle.m_131182_()) != null) {
            Object link;
            if (event.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
                if (BookLink.isBookLink(event.m_130623_())) {
                    BookLink link2 = BookLink.from(this.getBook(), event.m_130623_());
                    Book book = BookDataManager.get().getBook(link2.bookId);
                    if (link2.entryId != null) {
                        BookEntry entry = book.getEntry(link2.entryId);
                        if (!BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, entry)) {
                            return false;
                        }
                        int page = link2.pageNumber;
                        if (link2.pageAnchor != null) {
                            page = entry.getPageNumberForAnchor(link2.pageAnchor);
                        }
                        BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), this.openPagesIndex * 2);
                        BookGuiManager.get().openEntry(link2.bookId, link2.entryId, page);
                    } else if (link2.categoryId != null) {
                        BookGuiManager.get().openEntry(link2.bookId, link2.categoryId, null, 0);
                    } else {
                        BookGuiManager.get().openEntry(link2.bookId, null, null, 0);
                    }
                    return true;
                }
                if (PatchouliLink.isPatchouliLink(event.m_130623_())) {
                    link = PatchouliLink.from(event.m_130623_());
                    if (((PatchouliLink)link).bookId != null) {
                        this.simulateEscClosing = true;
                        ModonomiconPatchouliIntegration.openEntry(((PatchouliLink)link).bookId, ((PatchouliLink)link).entryId, ((PatchouliLink)link).pageNumber);
                        return true;
                    }
                }
                if (ItemLinkRenderer.isItemLink(event.m_130623_())) {
                    if (ModonomiconJeiIntegration.isJeiLoaded()) {
                        String itemId = event.m_130623_().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
                        ItemStack itemStack = ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(itemId));
                        this.m_7379_();
                        if (Screen.m_96638_()) {
                            ModonomiconJeiIntegration.showUses(itemStack);
                        } else {
                            ModonomiconJeiIntegration.showRecipe(itemStack);
                        }
                        if (!ModonomiconJeiIntegration.isJEIRecipesGuiOpen()) {
                            this.f_96541_.pushGuiLayer((Screen)this);
                        }
                    }
                    return true;
                }
            }
            if (event.m_130622_() == ClickEvent.Action.RUN_COMMAND && CommandLink.isCommandLink(event.m_130623_())) {
                link = CommandLink.from(this.getBook(), event.m_130623_());
                Book book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    if (BookUnlockCapability.canRunFor((Player)this.f_96541_.f_91074_, command)) {
                        Networking.sendToServer(new ClickCommandLinkMessage(((CommandLink)link).bookId, ((CommandLink)link).commandId));
                        BookUnlockCapability.setRunFor((Player)this.f_96541_.f_91074_, command);
                    }
                    return true;
                }
            }
        }
        return super.m_5561_(pStyle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookLeft = (this.f_96543_ - 272) / 2;
        this.bookTop = (this.f_96544_ - 178) / 2;
        this.maxOpenPagesIndex = (int)Math.ceil((float)this.entry.getPages().size() / 2.0f);
        this.beginDisplayPages();
        this.m_142416_(new BackButton(this, this.f_96543_ / 2 - 9, this.bookTop + 180 - 4));
        this.m_142416_(new ArrowButton(this, this.bookLeft - 4, this.bookTop + 180 - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.m_142416_(new ArrowButton(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        this.m_142416_(new ExitButton(this, this.bookLeft + 272 - 10, this.bookTop - 2, this::handleExitButton));
    }

    public void m_96624_() {
        super.m_96624_();
        if (!BookContentScreen.m_96638_()) {
            ++this.ticksInBook;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean clickPage;
        Style style;
        if (pButton == 0 && (style = this.getClickedComponentStyleAt(pMouseX, pMouseY)) != null && this.m_5561_(style)) {
            return true;
        }
        boolean bl = clickPage = this.clickPage(this.leftPageRenderer, pMouseX, pMouseY, pButton) || this.clickPage(this.rightPageRenderer, pMouseX, pMouseY, pButton);
        if (this.clickOutsideEntry(pMouseX, pMouseY)) {
            this.m_7379_();
        }
        return clickPage || super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

