/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class BookSearchScreen
extends Screen
implements BookScreenWithButtons {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    private final BookOverviewScreen parentScreen;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookEntry> allEntries;
    private EditBox searchField;
    private BookTextHolder infoText;
    private int bookLeft;
    private int bookTop;
    private List<Component> tooltip;

    protected BookSearchScreen(BookOverviewScreen parentScreen) {
        super((Component)new TranslatableComponent("modonomicon.gui.search.screen.title"));
        this.parentScreen = parentScreen;
        this.infoText = new BookTextHolder("modonomicon.gui.search.info");
    }

    public void handleButtonEntry(Button button) {
        BookEntry entry = ((EntryListButton)button).getEntry();
        BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(PoseStack poseStack, Component s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(poseStack, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(PoseStack poseStack, Component s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.f_96547_.m_92852_((FormattedText)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(poseStack, s, f, f2 + 9.0f * (1.0f - scale), color);
    }

    public BookOverviewScreen getParentScreen() {
        return this.parentScreen;
    }

    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    public void handleArrowButton(Button button) {
        this.flipPage(((ArrowButton)button).left, true);
    }

    public void handleExitButton(Button button) {
        this.m_7379_();
    }

    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentScreen.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.m_96597_(pPoseStack, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createSearchBar() {
        this.searchField = new EditBox(this.f_96547_, 160, 170, 90, 12, (Component)new TextComponent(""));
        this.searchField.m_94199_(32);
        this.searchField.m_94190_(false);
        this.searchField.m_5755_(true);
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.f_169369_.remove(b);
            this.m_6702_().remove(b);
            this.f_169368_.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.m_94155_().toLowerCase();
        this.allEntries.stream().filter(e -> e.matchesQuery(query)).forEach(this.visibleEntries::add);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private List<BookEntry> getEntries() {
        return this.parentScreen.getBook().getEntries().values().stream().toList();
    }

    private boolean clickOutsideEntry(double pMouseX, double pMouseY) {
        return pMouseX < (double)(this.bookLeft - 20) || pMouseX > (double)(this.bookLeft + 272 + 20) || pMouseY < (double)(this.bookTop - 20) || pMouseY > (double)(this.bookTop + 180 + 20);
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        int blitOffset = this.m_93252_();
        this.m_93250_(-1300);
        this.m_7333_(pPoseStack);
        this.m_93250_(blitOffset);
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)this.bookLeft, (double)this.bookTop, 0.0);
        BookContentScreen.renderBookBackground(pPoseStack, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(pPoseStack, this.m_96636_(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(pPoseStack, (Component)new TranslatableComponent("modonomicon.gui.search.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentScreen.drawTitleSeparator(pPoseStack, this.parentScreen.getBook(), 74, 27);
            BookContentScreen.drawTitleSeparator(pPoseStack, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(this.infoText, this.f_96547_, pPoseStack, 12, 37, 124);
        }
        if (!this.searchField.m_94155_().isEmpty()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BookContentScreen.drawFromTexture(pPoseStack, this.parentScreen.getBook(), this.searchField.f_93620_ - 8, this.searchField.f_93621_, 140, 183, 99, 14);
            TextComponent searchComponent = new TextComponent(this.searchField.m_94155_());
            this.f_96547_.m_92889_(pPoseStack, (Component)searchComponent, (float)(this.searchField.f_93620_ + 7), (float)(this.searchField.f_93621_ + 1), 0);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.m_94155_().isEmpty()) {
                this.drawCenteredStringNoShadow(pPoseStack, (Component)new TranslatableComponent("modonomicon.gui.search.no_results"), 203, 80, 0x333333);
                pPoseStack.m_85841_(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(pPoseStack, (Component)new TranslatableComponent("modonomicon.gui.search.sad"), 101, 47, 0x999999);
                pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(pPoseStack, (Component)new TranslatableComponent("modonomicon.gui.search.no_results"), 203, 80, 0x333333);
            }
        }
        pPoseStack.m_85849_();
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.drawTooltip(pPoseStack, pMouseX, pMouseY);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.m_94155_();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                BookEntry entry = this.visibleEntries.get(0);
                BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
                return true;
            }
        } else if (this.searchField.m_7933_(key, scanCode, modifiers)) {
            if (!this.searchField.m_94155_().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public void m_7856_() {
        super.m_7856_();
        this.bookLeft = (this.f_96543_ - 272) / 2;
        this.bookTop = (this.f_96544_ - 178) / 2;
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, e.getCategory()) && BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, e)).sorted(Comparator.comparing(a -> I18n.m_118938_((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createSearchBar();
        this.createEntryList();
        this.m_142416_((GuiEventListener)new ArrowButton(this, this.bookLeft - 4, this.bookTop + 180 - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.m_142416_((GuiEventListener)new ArrowButton(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        this.m_142416_((GuiEventListener)new ExitButton(this, this.bookLeft + 272 - 10, this.bookTop - 2, this::handleExitButton));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.clickOutsideEntry(pMouseX, pMouseY)) {
            this.m_7379_();
        }
        return this.searchField.m_6375_(pMouseX - (double)this.bookLeft, pMouseY - (double)this.bookTop, pButton) || super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_5534_(char c, int i) {
        String currQuery = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, i)) {
            if (!this.searchField.m_94155_().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.m_5534_(c, i);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            EntryListButton button = new EntryListButton(this, this.visibleEntries.get(start + i), this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.m_142416_((GuiEventListener)button);
            this.entryButtons.add(button);
        }
    }
}

