/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class EntryListButton
extends Button {
    private static final int ANIM_TIME = 5;
    private final BookSearchScreen parent;
    private final BookEntry entry;
    private float timeHovered;

    public EntryListButton(BookSearchScreen parent, BookEntry entry, int pX, int pY, Button.OnPress pOnPress) {
        super(pX, pY, 124, 10, (Component)new TranslatableComponent(entry.getName()), pOnPress);
        this.parent = parent;
        this.entry = entry;
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    private int getEntryColor() {
        return 0;
    }

    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93623_) {
            this.timeHovered = this.m_198029_() ? Math.min(5.0f, this.timeHovered + ClientTicks.delta) : Math.max(0.0f, this.timeHovered - ClientTicks.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.m_198029_() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = !BookUnlockCapability.isUnlockedFor((Player)Minecraft.m_91087_().f_91074_, this.entry);
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            GuiComponent.m_93172_((PoseStack)ms, (int)(this.f_93620_ * 2), (int)(this.f_93621_ * 2), (int)((this.f_93620_ + (int)((float)this.f_93618_ * widthFract)) * 2), (int)((this.f_93621_ + this.f_93619_) * 2), (int)0x22000000);
            RenderSystem.m_69478_();
            if (locked) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                BookContentScreen.drawLock(ms, this.parent.getParentScreen().getBook(), this.f_93620_ * 2 + 2, this.f_93621_ * 2 + 2);
            } else {
                this.entry.getIcon().render(ms, this.f_93620_ * 2 + 2, this.f_93621_ * 2 + 2);
            }
            ms.m_85841_(2.0f, 2.0f, 2.0f);
            TranslatableComponent name = locked ? new TranslatableComponent("modonomicon.gui.search.entry.locked") : new TranslatableComponent(this.entry.getName());
            Minecraft.m_91087_().f_91062_.m_92889_(ms, (Component)name, (float)(this.f_93620_ + 12), (float)this.f_93621_, this.getEntryColor());
        }
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        if (this.entry != null) {
            // empty if block
        }
    }
}

