/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererFactory;
import com.klikli_dev.modonomicon.client.gui.book.markdown.CoreComponentNodeRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ListItemComponent;
import com.klikli_dev.relocated.commonmark.Extension;
import com.klikli_dev.relocated.commonmark.internal.renderer.NodeRendererMap;
import com.klikli_dev.relocated.commonmark.internal.renderer.text.ListHolder;
import com.klikli_dev.relocated.commonmark.node.Node;
import com.klikli_dev.relocated.commonmark.renderer.NodeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;

public class ComponentRenderer {
    private final List<ComponentNodeRendererFactory> nodeRendererFactories;
    private final List<LinkRenderer> linkRenderers;
    private final List<MutableComponent> components;
    private final boolean renderSoftLineBreaks;
    private final boolean replaceSoftLineBreaksWithSpace;
    private final TextColor linkColor;
    private MutableComponent currentComponent;
    private Style currentStyle;
    private ListHolder listHolder;

    private ComponentRenderer(Builder builder) {
        this.renderSoftLineBreaks = builder.renderSoftLineBreaks;
        this.replaceSoftLineBreaksWithSpace = builder.replaceSoftLineBreaksWithSpace;
        this.linkColor = builder.linkColor;
        this.currentStyle = builder.style;
        this.linkRenderers = builder.linkRenderers;
        this.components = new ArrayList<MutableComponent>();
        this.currentComponent = new TranslatableComponent("");
        this.nodeRendererFactories = new ArrayList<ComponentNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(CoreComponentNodeRenderer::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<MutableComponent> render(Node node, Book book) {
        RendererContext context = new RendererContext(book);
        context.render(node);
        context.cleanupPostRender();
        return context.getComponents();
    }

    public static class Builder {
        private final List<LinkRenderer> linkRenderers = new ArrayList<LinkRenderer>();
        private final List<ComponentNodeRendererFactory> nodeRendererFactories = new ArrayList<ComponentNodeRendererFactory>();
        private boolean renderSoftLineBreaks = false;
        private boolean replaceSoftLineBreaksWithSpace = true;
        private TextColor linkColor = TextColor.m_131266_((int)0x5555FF);
        private Style style = Style.f_131099_;

        public ComponentRenderer build() {
            return new ComponentRenderer(this);
        }

        public Builder renderSoftLineBreaks(boolean renderSoftLineBreaks) {
            this.renderSoftLineBreaks = renderSoftLineBreaks;
            return this;
        }

        public Builder replaceSoftLineBreaksWithSpace(boolean replaceSoftLineBreaksWithSpace) {
            this.replaceSoftLineBreaksWithSpace = replaceSoftLineBreaksWithSpace;
            return this;
        }

        public Builder linkColor(TextColor linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder nodeRendererFactory(ComponentNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof ComponentRendererExtension)) continue;
                ComponentRendererExtension componentRendererExtension = (ComponentRendererExtension)extension;
                componentRendererExtension.extend(this);
            }
            return this;
        }

        public Builder linkRenderers(Collection<? extends LinkRenderer> linkRenderers) {
            this.linkRenderers.addAll(linkRenderers);
            return this;
        }
    }

    private class RendererContext
    implements ComponentNodeRendererContext {
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();
        private final Book book;

        private RendererContext(Book book) {
            this.book = book;
            for (int i = ComponentRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                ComponentNodeRendererFactory nodeRendererFactory = ComponentRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public MutableComponent getCurrentComponent() {
            return ComponentRenderer.this.currentComponent;
        }

        @Override
        public void setCurrentComponent(MutableComponent component) {
            ComponentRenderer.this.currentComponent = component;
        }

        @Override
        public List<MutableComponent> getComponents() {
            return ComponentRenderer.this.components;
        }

        @Override
        public ListHolder getListHolder() {
            return ComponentRenderer.this.listHolder;
        }

        @Override
        public void setListHolder(ListHolder listHolder) {
            ComponentRenderer.this.listHolder = listHolder;
        }

        @Override
        public Style getCurrentStyle() {
            return ComponentRenderer.this.currentStyle;
        }

        @Override
        public void setCurrentStyle(Style style) {
            ComponentRenderer.this.currentStyle = style;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        @Override
        public void cleanupPostRender() {
            if (!this.isEmptyComponent()) {
                this.finalizeCurrentComponent();
            }
        }

        @Override
        public boolean isEmptyComponent() {
            return ((TranslatableComponent)this.getCurrentComponent()).m_131328_().isEmpty() && this.getCurrentComponent().m_7360_().isEmpty();
        }

        @Override
        public void finalizeCurrentComponent() {
            this.getComponents().add(this.getCurrentComponent());
            this.setCurrentComponent((MutableComponent)(this.getListHolder() == null ? new TranslatableComponent("") : new ListItemComponent(this.getListHolder(), "")));
        }

        @Override
        public boolean getRenderSoftLineBreaks() {
            return ComponentRenderer.this.renderSoftLineBreaks;
        }

        @Override
        public boolean getReplaceSoftLineBreaksWithSpace() {
            return ComponentRenderer.this.replaceSoftLineBreaksWithSpace;
        }

        @Override
        public TextColor getLinkColor() {
            return ComponentRenderer.this.linkColor;
        }

        @Override
        public List<LinkRenderer> getLinkRenderers() {
            return ComponentRenderer.this.linkRenderers;
        }

        @Override
        public Book getBook() {
            return this.book;
        }
    }

    public static interface ComponentRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }
}

