/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.relocated.commonmark.internal.renderer.text.BulletListHolder;
import com.klikli_dev.relocated.commonmark.internal.renderer.text.ListHolder;
import com.klikli_dev.relocated.commonmark.internal.renderer.text.OrderedListHolder;
import com.klikli_dev.relocated.commonmark.node.AbstractVisitor;
import com.klikli_dev.relocated.commonmark.node.Block;
import com.klikli_dev.relocated.commonmark.node.BulletList;
import com.klikli_dev.relocated.commonmark.node.Document;
import com.klikli_dev.relocated.commonmark.node.Emphasis;
import com.klikli_dev.relocated.commonmark.node.HardLineBreak;
import com.klikli_dev.relocated.commonmark.node.Heading;
import com.klikli_dev.relocated.commonmark.node.Link;
import com.klikli_dev.relocated.commonmark.node.ListItem;
import com.klikli_dev.relocated.commonmark.node.Node;
import com.klikli_dev.relocated.commonmark.node.OrderedList;
import com.klikli_dev.relocated.commonmark.node.Paragraph;
import com.klikli_dev.relocated.commonmark.node.SoftLineBreak;
import com.klikli_dev.relocated.commonmark.node.StrongEmphasis;
import com.klikli_dev.relocated.commonmark.node.Text;
import com.klikli_dev.relocated.commonmark.renderer.NodeRenderer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class CoreComponentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final ComponentNodeRendererContext context;

    public CoreComponentNodeRenderer(ComponentNodeRendererContext context) {
        this.context = context;
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return new HashSet<Class<? extends Node>>(Arrays.asList(Document.class, Heading.class, Paragraph.class, BulletList.class, Link.class, ListItem.class, OrderedList.class, Emphasis.class, StrongEmphasis.class, Text.class, SoftLineBreak.class, HardLineBreak.class));
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(BulletList bulletList) {
        ListItem item;
        this.context.setListHolder(new BulletListHolder(this.context.getListHolder(), bulletList));
        this.visitChildren(bulletList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = bulletList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    @Override
    public void visit(Emphasis emphasis) {
        boolean italic = this.context.getCurrentStyle().m_131161_();
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131155_(Boolean.valueOf(true)));
        this.visitChildren(emphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131155_(Boolean.valueOf(italic)));
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.context.getCurrentComponent().m_7220_((Component)new TextComponent("\n"));
        this.visitChildren(hardLineBreak);
    }

    @Override
    public void visit(Link link) {
        for (LinkRenderer renderer : this.context.getLinkRenderers()) {
            if (!renderer.visit(link, this::visitChildren, this.context)) continue;
            return;
        }
        TextColor currentColor = this.context.getCurrentStyle().m_131135_();
        TranslatableComponent hoverComponent = new TranslatableComponent("modonomicon.gui.hover.http_link", new Object[]{link.getDestination()});
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131148_(currentColor == null ? this.context.getLinkColor() : currentColor).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link.getDestination())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent)));
        this.visitChildren(link);
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131148_(currentColor).m_131142_(null).m_131144_(null));
    }

    @Override
    public void visit(ListItem listItem) {
        this.context.finalizeCurrentComponent();
        ListHolder listHolder = this.context.getListHolder();
        if (listHolder != null && listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)listHolder;
            this.context.getCurrentComponent().m_7220_((Component)new TranslatableComponent(orderedListHolder.getIndent() + orderedListHolder.getCounter() + orderedListHolder.getDelimiter() + " ").m_130948_(Style.f_131099_));
            this.visitChildren(listItem);
            orderedListHolder.increaseCounter();
        } else if (listHolder != null && listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)listHolder;
            this.context.getCurrentComponent().m_7220_((Component)new TranslatableComponent(bulletListHolder.getIndent() + bulletListHolder.getMarker() + " ").m_130948_(Style.f_131099_));
            this.visitChildren(listItem);
        }
    }

    @Override
    public void visit(OrderedList orderedList) {
        ListItem item;
        this.context.setListHolder(new OrderedListHolder(this.context.getListHolder(), orderedList));
        this.visitChildren(orderedList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = orderedList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        if (this.context.getRenderSoftLineBreaks()) {
            this.context.getCurrentComponent().m_130946_("\n");
        } else if (this.context.getReplaceSoftLineBreaksWithSpace()) {
            this.context.getCurrentComponent().m_7220_((Component)new TextComponent(" "));
        }
        this.visitChildren(softLineBreak);
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        boolean emphasis = this.context.getCurrentStyle().m_131154_();
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131136_(Boolean.valueOf(true)));
        this.visitChildren(strongEmphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().m_131136_(Boolean.valueOf(emphasis)));
    }

    @Override
    public void visit(Text text) {
        this.context.getCurrentComponent().m_7220_((Component)new TranslatableComponent(text.getLiteral()).m_130948_(this.context.getCurrentStyle()));
        this.visitChildren(text);
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

