/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.Modonomicon;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TickTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class AdvancementsGenerator
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Advancement> advancements;

    public AdvancementsGenerator(DataGenerator generator) {
        this.generator = generator;
        this.advancements = new HashMap<ResourceLocation, Advancement>();
    }

    private static Path getPath(Path path, Advancement advancement) {
        ResourceLocation id = advancement.m_138327_();
        return path.resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json");
    }

    private static TranslatableComponent text(String name, String type) {
        return new TranslatableComponent("advancements.modonomicon." + name + "." + type);
    }

    public static TranslatableComponent title(String name) {
        return AdvancementsGenerator.text(name, "title");
    }

    public static TranslatableComponent descr(String name) {
        return AdvancementsGenerator.text(name, "description");
    }

    private void start() {
        Advancement root = this.add(Advancement.Builder.m_138353_().m_138386_("modonomicon_present", (CriterionTriggerInstance)new TickTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).m_138403_(new ResourceLocation("modonomicon", "modonomicon/root")));
    }

    private Advancement add(Advancement advancement) {
        if (this.advancements.containsKey(advancement.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
        }
        this.advancements.put(advancement.m_138327_(), advancement);
        return advancement;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path folder = this.generator.m_123916_();
        this.start();
        for (Advancement advancement : this.advancements.values()) {
            Path path = AdvancementsGenerator.getPath(folder, advancement);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException exception) {
                Modonomicon.LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)exception);
            }
        }
    }

    public String m_6055_() {
        return "Advancements: modonomicon";
    }
}

