/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.SimulateResultImpl;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class DenseMultiblock
extends AbstractMultiblock {
    public static final ResourceLocation TYPE = Modonomicon.loc("dense");
    private static final Gson GSON = new GsonBuilder().create();
    private final String[][] pattern;
    private final Vec3i size;
    private final Map<Character, StateMatcher> targets;
    private StateMatcher[][][] stateMatchers;

    public DenseMultiblock(String[][] pattern, Map<Character, StateMatcher> targets) {
        this.pattern = pattern;
        this.targets = targets;
        if (!targets.containsKey(Character.valueOf('_'))) {
            targets.put(Character.valueOf('_'), Matchers.ANY);
        }
        if (!targets.containsKey(Character.valueOf(' '))) {
            targets.put(Character.valueOf(' '), Matchers.AIR);
        }
        if (!targets.containsKey(Character.valueOf('0'))) {
            targets.put(Character.valueOf('0'), Matchers.AIR);
        }
        this.size = this.build(targets, DenseMultiblock.getPatternDimensions(pattern));
    }

    public static DenseMultiblock fromNetwork(FriendlyByteBuf buffer) {
        boolean symmetrical = buffer.readBoolean();
        int offX = buffer.m_130242_();
        int offY = buffer.m_130242_();
        int offZ = buffer.m_130242_();
        int viewOffX = buffer.m_130242_();
        int viewOffY = buffer.m_130242_();
        int viewOffZ = buffer.m_130242_();
        int sizeX = buffer.m_130242_();
        int sizeY = buffer.m_130242_();
        String[][] pattern = new String[sizeY][sizeX];
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                pattern[y][x] = buffer.m_130277_();
            }
        }
        HashMap<Character, StateMatcher> targets = new HashMap<Character, StateMatcher>();
        int targetCount = buffer.m_130242_();
        for (int i = 0; i < targetCount; ++i) {
            char key = buffer.readChar();
            ResourceLocation type = buffer.m_130281_();
            StateMatcher stateMatcher = LoaderRegistry.getStateMatcherNetworkLoader(type).fromNetwork(buffer);
            targets.put(Character.valueOf(key), stateMatcher);
        }
        DenseMultiblock multiblock = new DenseMultiblock(pattern, targets);
        multiblock.setSymmetrical(symmetrical);
        multiblock.setOffset(offX, offY, offZ);
        multiblock.setViewOffset(viewOffX, viewOffY, viewOffZ);
        return multiblock;
    }

    public static DenseMultiblock fromJson(JsonObject json) {
        String[][] pattern = (String[][])GSON.fromJson(json.get("pattern"), String[][].class);
        JsonObject jsonMapping = GsonHelper.m_13930_((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = DenseMultiblock.mappingFromJson(jsonMapping);
        DenseMultiblock multiblock = new DenseMultiblock(pattern, mapping);
        return DenseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    private static Vec3i getPatternDimensions(String[][] pattern) {
        int expectedLenX = -1;
        int expectedLenZ = -1;
        for (String[] arr : pattern) {
            if (expectedLenX == -1) {
                expectedLenX = arr.length;
            }
            if (arr.length != expectedLenX) {
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
            for (String s : arr) {
                if (expectedLenZ == -1) {
                    expectedLenZ = s.length();
                }
                if (s.length() == expectedLenZ) continue;
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
        }
        return new Vec3i(expectedLenX, pattern.length, expectedLenZ);
    }

    private Vec3i build(Map<Character, StateMatcher> stateMap, Vec3i dimensions) {
        boolean foundCenter = false;
        this.stateMatchers = new StateMatcher[dimensions.m_123341_()][dimensions.m_123342_()][dimensions.m_123343_()];
        for (int y = 0; y < dimensions.m_123342_(); ++y) {
            for (int x = 0; x < dimensions.m_123341_(); ++x) {
                for (int z = 0; z < dimensions.m_123343_(); ++z) {
                    char c = this.pattern[y][x].charAt(z);
                    if (!stateMap.containsKey(Character.valueOf(c))) {
                        throw new IllegalArgumentException("Character " + c + " isn't mapped");
                    }
                    StateMatcher matcher = stateMap.get(Character.valueOf(c));
                    if (c == '0') {
                        if (foundCenter) {
                            throw new IllegalArgumentException("A structure can't have two centers");
                        }
                        foundCenter = true;
                        this.offX = x;
                        this.offY = dimensions.m_123342_() - y - 1;
                        this.offZ = z;
                        this.setViewOffset();
                    }
                    this.stateMatchers[x][dimensions.m_123342_() - y - 1][z] = matcher;
                }
            }
        }
        if (!foundCenter) {
            throw new IllegalArgumentException("A structure can't have no center");
        }
        return dimensions;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Pair<BlockPos, Collection<Multiblock.SimulateResult>> simulate(Level world, BlockPos anchor, Rotation rotation, boolean forView, boolean disableOffset) {
        BlockPos disp;
        BlockPos blockPos = disp = forView ? new BlockPos(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).m_7954_(rotation) : new BlockPos(-this.offX, -this.offY, -this.offZ).m_7954_(rotation);
        if (disableOffset) {
            disp = BlockPos.f_121853_;
        }
        BlockPos origin = anchor.m_141952_((Vec3i)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (int x = 0; x < this.size.m_123341_(); ++x) {
            for (int y = 0; y < this.size.m_123342_(); ++y) {
                for (int z = 0; z < this.size.m_123343_(); ++z) {
                    BlockPos currDisp = new BlockPos(x, y, z).m_7954_(rotation);
                    BlockPos actionPos = origin.m_141952_((Vec3i)currDisp);
                    char currC = this.pattern[y][x].charAt(z);
                    ret.add(new SimulateResultImpl(actionPos, this.stateMatchers[x][y][z], Character.valueOf(currC)));
                }
            }
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(Level world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setWorld(world);
        if (x < 0 || y < 0 || z < 0 || x >= this.size.m_123341_() || y >= this.size.m_123342_() || z >= this.size.m_123343_()) {
            return false;
        }
        BlockPos checkPos = start.m_141952_((Vec3i)new BlockPos(x, y, z).m_7954_(AbstractMultiblock.fixHorizontal(rotation)));
        TriPredicate<BlockGetter, BlockPos, BlockState> pred = this.stateMatchers[x][y][z].getStatePredicate();
        BlockState state = world.m_8055_(checkPos).m_60717_(rotation);
        return pred.test((BlockGetter)world, checkPos, state);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.m_130130_(this.offX);
        buffer.m_130130_(this.offY);
        buffer.m_130130_(this.offZ);
        buffer.m_130130_(this.viewOffX);
        buffer.m_130130_(this.viewOffY);
        buffer.m_130130_(this.viewOffZ);
        buffer.m_130130_(this.size.m_123341_());
        buffer.m_130130_(this.size.m_123342_());
        for (int y = 0; y < this.size.m_123342_(); ++y) {
            for (int x = 0; x < this.size.m_123341_(); ++x) {
                buffer.m_130070_(this.pattern[y][x]);
            }
        }
        buffer.m_130130_(this.targets.size());
        for (Map.Entry<Character, StateMatcher> entry : this.targets.entrySet()) {
            buffer.writeChar((int)entry.getKey().charValue());
            buffer.m_130085_(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }
}

