/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TagMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("tag");
    private final BlockState displayState;
    private final Supplier<TagKey<Block>> tag;
    private final Supplier<Map<String, String>> props;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected TagMatcher(Supplier<TagKey<Block>> tag, Supplier<Map<String, String>> props) {
        this(null, tag, props);
    }

    protected TagMatcher(BlockState displayState, Supplier<TagKey<Block>> tag, Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.tag = tag;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.m_204336_(this.tag.get()) && TagMatcher.checkProps(blockState, this.props);
    }

    public static TagMatcher fromJson(JsonObject json) {
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = new BlockStateParser(new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), false).m_116806_(false).m_116808_();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for TagStateMatcher.", e);
            }
        }
        try {
            Object tagString = GsonHelper.m_13906_((JsonObject)json, (String)"tag");
            if (!((String)tagString).startsWith("#")) {
                tagString = "#" + (String)tagString;
            }
            BlockStateParser parser = new BlockStateParser(new StringReader((String)tagString), true).m_116806_(false);
            TagKey tag = parser.m_205617_();
            Map props = parser.m_116846_();
            return new TagMatcher(displayState, () -> tag, () -> props);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse Tag and BlockState properties from json member \"tag\" for TagMatcher.", e);
        }
    }

    public static TagMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = null;
            if (buffer.readBoolean()) {
                displayState = new BlockStateParser(new StringReader(buffer.m_130277_()), true).m_116806_(false).m_116808_();
            }
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)buffer.m_130281_());
            Map props = buffer.m_178368_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_);
            return new TagMatcher(displayState, () -> tag, () -> props);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse TagMatcher from network.", e);
        }
    }

    public static boolean checkProps(BlockState state, Supplier<Map<String, String>> props) {
        for (Map.Entry<String, String> entry : props.get().entrySet()) {
            Property prop = state.m_60734_().m_49965_().m_61081_(entry.getKey());
            if (prop == null) {
                return false;
            }
            Comparable value = prop.m_6215_(entry.getValue()).orElse(null);
            if (value == null) {
                return false;
            }
            if (state.m_61143_(prop).equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        if (this.displayState != null) {
            return this.displayState;
        }
        ImmutableList all = ImmutableList.copyOf((Iterable)Registry.f_122824_.m_206058_(this.tag.get()));
        if (all.isEmpty()) {
            return Blocks.f_50752_.m_49966_();
        }
        int idx = (int)(ticks / 20L % (long)all.size());
        return ((Block)((Holder)all.get(idx)).m_203334_()).m_49966_();
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
        }
        buffer.m_130085_(this.tag.get().f_203868_());
        buffer.m_178355_(this.props.get(), FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.props, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagMatcher that = (TagMatcher)o;
        return this.tag.equals(that.tag) && this.props.equals(that.props) && this.displayState.equals(that.displayState);
    }
}

