/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import vazkii.quark.addons.oddities.client.screen.CrateScreen;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.module.VariantFurnacesModule;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.client.tooltip.EnchantedBookTooltips;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.module.AncientTomesModule;
import vazkii.quark.content.tools.module.ColorRunesModule;
import vazkii.quark.content.tools.module.PickarangModule;
import vazkii.quark.content.tweaks.recipe.ElytraDuplicationRecipe;
import vazkii.quark.integration.jei.ElytraDuplicationExtension;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("quark", "quark");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AncientTomesModule.ancient_tome});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        List<ItemStack> disabledItems = RequiredModTooltipHandler.disabledItems();
        if (!disabledItems.isEmpty()) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, disabledItems);
        }
        ModuleLoader.INSTANCE.initJEICompat(() -> {
            NonNullList stacks = NonNullList.m_122779_();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                IQuarkBlock quarkBlock;
                BlockItem blockItem;
                Block patt3331$temp;
                IQuarkItem quarkItem;
                ResourceLocation loc = item.getRegistryName();
                if (loc == null || !loc.m_135827_().equals("quark") || (!(item instanceof IQuarkItem) || (quarkItem = (IQuarkItem)item).isEnabled()) && (!(item instanceof BlockItem) || !((patt3331$temp = (blockItem = (BlockItem)item).m_40614_()) instanceof IQuarkBlock) || (quarkBlock = (IQuarkBlock)patt3331$temp).isEnabled())) continue;
                item.m_6787_(CreativeModeTab.f_40754_, stacks);
            }
            if (!stacks.isEmpty()) {
                Minecraft.m_91087_().m_18689_(() -> jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)stacks));
            }
        });
    }

    public void registerVanillaCategoryExtensions(@Nonnull IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ElytraDuplicationRecipe.class, ElytraDuplicationExtension::new);
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(PickarangModule.pickarang, Items.f_42415_, registration, factory);
            this.registerPickarangAnvilRepairs(PickarangModule.flamarang, Items.f_42418_, registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(ColorRunesModule.class)) {
            this.registerRuneAnvilRecipes(registration, factory);
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        if (ModuleLoader.INSTANCE.isModuleEnabled(VariantFurnacesModule.class)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.deepslateFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.blackstoneFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
        }
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CrateScreen.class, (IGuiContainerHandler)new CrateGuiHandler());
        registration.addRecipeClickArea(BackpackInventoryScreen.class, 137, 29, 10, 13, new RecipeType[]{RecipeTypes.CRAFTING});
    }

    private void registerAncientTomeAnvilRecipes(@Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Enchantment enchant : AncientTomesModule.validEnchants) {
            EnchantmentInstance data = new EnchantmentInstance(enchant, enchant.m_6586_());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.m_41161_((EnchantmentInstance)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(enchant)), Collections.singletonList(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(data.f_44947_, data.f_44948_ + 1)))));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    private void registerRuneAnvilRecipes(@Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        Random random = new Random();
        Stream<Object> displayItems = ModuleLoader.INSTANCE.isModuleEnabled(ImprovedTooltipsModule.class) && ImprovedTooltipsModule.enchantingTooltips ? EnchantedBookTooltips.getTestItems().stream() : Stream.of(Items.f_42388_, Items.f_42390_, Items.f_42391_, Items.f_42389_, Items.f_42392_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42741_, Items.f_42740_, Items.f_42411_, Items.f_42717_, Items.f_42713_, Items.f_42523_, Items.f_42574_, PickarangModule.pickarang).map(ItemStack::new);
        List used = displayItems.filter(it -> {
            QuarkItem qItem;
            Item patt7234$temp = it.m_41720_();
            return !(patt7234$temp instanceof QuarkItem) || (qItem = (QuarkItem)patt7234$temp).isEnabled();
        }).map(item -> QuarkJeiPlugin.makeEnchantedDisplayItem(item, random)).collect(Collectors.toList());
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Item rune : MiscUtil.getTagValues(BuiltinRegistries.f_206379_, ColorRunesModule.runesTag)) {
            ItemStack runeStack = new ItemStack((ItemLike)rune);
            recipes.add(factory.createAnvilRecipe(used, Collections.singletonList(runeStack), used.stream().map(stack -> {
                ItemStack output = stack.m_41777_();
                ItemNBTHelper.setBoolean((ItemStack)output, (String)"quark:RuneAttached", (boolean)true);
                ItemNBTHelper.setCompound((ItemStack)output, (String)"quark:RuneColor", (CompoundTag)runeStack.serializeNBT());
                return output;
            }).collect(Collectors.toList())));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    @Nonnull
    private static ItemStack makeEnchantedDisplayItem(ItemStack input, Random random) {
        ItemStack stack = input.m_41777_();
        stack.m_41714_((Component)new TranslatableComponent("quark.jei.any_enchanted"));
        if (stack.getItemEnchantability() <= 0) {
            stack.m_41663_(Enchantments.f_44986_, 3);
            return stack;
        }
        return EnchantmentHelper.m_44877_((Random)random, (ItemStack)stack, (int)25, (boolean)false);
    }

    private void registerPickarangAnvilRepairs(Item pickarang, Item repairMaterial, @Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((ItemLike)pickarang);
        nearlyBroken.m_41721_(nearlyBroken.m_41776_());
        ItemStack veryDamaged = nearlyBroken.m_41777_();
        veryDamaged.m_41721_(veryDamaged.m_41776_() * 3 / 4);
        ItemStack damaged = nearlyBroken.m_41777_();
        damaged.m_41721_(damaged.m_41776_() * 2 / 4);
        IJeiAnvilRecipe materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((ItemLike)repairMaterial)), Collections.singletonList(veryDamaged));
        IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(RecipeTypes.ANVIL, Arrays.asList(materialRepair, toolRepair));
    }

    private static class CrateGuiHandler
    implements IGuiContainerHandler<CrateScreen> {
        private CrateGuiHandler() {
        }

        @Nonnull
        public List<Rect2i> getGuiExtraAreas(@Nonnull CrateScreen containerScreen) {
            return containerScreen.getExtraAreas();
        }
    }
}

