/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.smartresearchcost.mixin;

import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.PlayerReference;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ResearchTree.class}, remap=false)
public abstract class MixinResearchTree {
    @Shadow
    @Final
    protected List<PlayerReference> researchShares;
    @Shadow
    public static boolean isPenalty;

    @Shadow
    public abstract float getTeamResearchCostIncreaseMultiplier();

    @Redirect(method={"getResearchCost"}, at=@At(value="INVOKE", target="Liskallia/vault/research/ResearchTree;getTeamResearchCostIncreaseMultiplier()F"))
    private float doNotIncreaseIfAlreadyResearched(ResearchTree instance, Research research) {
        if (research == null || isPenalty) {
            return instance.getTeamResearchCostIncreaseMultiplier();
        }
        int notUnlocked = 0;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return instance.getTeamResearchCostIncreaseMultiplier();
        }
        ServerLevel ow = server.m_129783_();
        if (ow == null) {
            return instance.getTeamResearchCostIncreaseMultiplier();
        }
        for (PlayerReference playerReference : this.researchShares) {
            UUID playerId = playerReference.getId();
            if (playerId == null) {
                return instance.getTeamResearchCostIncreaseMultiplier();
            }
            if (PlayerResearchesData.get((ServerLevel)ow).getResearches(playerId).isResearched(research)) continue;
            ++notUnlocked;
        }
        return (float)notUnlocked * 0.5f;
    }
}

