/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.smartresearchcost.network.packets;

import com.radimous.smartresearchcost.network.SmartResearchCostNetwork;
import com.radimous.smartresearchcost.network.packets.GetSharedResearchTreesS2C;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.PlayerReference;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class GetSharedResearchTreesC2S {
    public static void encode(GetSharedResearchTreesC2S msg, FriendlyByteBuf packetBuffer) {
    }

    public static GetSharedResearchTreesC2S decode(FriendlyByteBuf packetBuffer) {
        return new GetSharedResearchTreesC2S();
    }

    public static void handle(GetSharedResearchTreesC2S msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> GetSharedResearchTreesC2S.handleResearchTeamTrees(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleResearchTeamTrees(GetSharedResearchTreesC2S msg, ServerPlayer sender) {
        if (sender != null) {
            MinecraftServer svr = sender.m_20194_();
            if (svr == null) {
                return;
            }
            ServerLevel ow = svr.m_129783_();
            if (ow == null) {
                return;
            }
            HashMap<PlayerReference, ResearchTree> researchTrees = new HashMap<PlayerReference, ResearchTree>();
            PlayerResearchesData researchData = PlayerResearchesData.get((ServerLevel)ow);
            ResearchTree resTree = researchData.getResearches(sender.m_142081_());
            List shares = resTree.getResearchShares();
            for (PlayerReference playerReference : shares) {
                ResearchTree researches = PlayerResearchesData.get((ServerLevel)ow).getResearches(playerReference.getId());
                if (researches == null) continue;
                researchTrees.put(playerReference, researches);
            }
            SmartResearchCostNetwork.sendToPlayer(new GetSharedResearchTreesS2C(researchTrees), sender);
        }
    }
}

