/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.smartresearchcost.network.packets;

import com.radimous.smartresearchcost.Smartresearchcost;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.PlayerReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class GetSharedResearchTreesS2C {
    Map<PlayerReference, ResearchTree> researchTrees;

    public GetSharedResearchTreesS2C(Map<PlayerReference, ResearchTree> researchTrees) {
        this.researchTrees = researchTrees;
    }

    public static void encode(GetSharedResearchTreesS2C msg, FriendlyByteBuf packetBuffer) {
        msg.researchTrees.forEach((playerReference, researchTree) -> {
            packetBuffer.m_130079_(playerReference.serialize());
            packetBuffer.m_130079_(researchTree.serializeNBT());
        });
    }

    public static GetSharedResearchTreesS2C decode(FriendlyByteBuf packetBuffer) {
        HashMap<PlayerReference, ResearchTree> researchTrees = new HashMap<PlayerReference, ResearchTree>();
        while (packetBuffer.isReadable()) {
            CompoundTag resTreeTag;
            CompoundTag playerRefTag = packetBuffer.m_130260_();
            if (playerRefTag == null || !packetBuffer.isReadable() || (resTreeTag = packetBuffer.m_130260_()) == null) continue;
            researchTrees.put(new PlayerReference(playerRefTag), new ResearchTree(resTreeTag));
        }
        return new GetSharedResearchTreesS2C(researchTrees);
    }

    public static void handle(GetSharedResearchTreesS2C msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> GetSharedResearchTreesS2C.handleResearchTeamTrees(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleResearchTeamTrees(GetSharedResearchTreesS2C msg, ServerPlayer sender) {
        Smartresearchcost.teamResearches = msg.researchTrees;
    }
}

