/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.craftingstation.Configs;
import tfar.craftingstation.CraftingStationContainer;
import tfar.craftingstation.init.ModBlockEntityTypes;
import tfar.craftingstation.init.ModBlocks;
import tfar.craftingstation.init.ModMenuTypes;
import tfar.craftingstation.network.PacketHandler;

@Mod(value="craftingstation")
public class CraftingStation {
    public static final String MODID = "craftingstation";
    public static final TagKey<BlockEntityType<?>> blacklisted = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)new ResourceLocation("craftingstation", "blacklisted"));
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Configs.Server SERVER;
    public static final Configs.Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public CraftingStation() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        IEventBus iEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        iEventBus.addListener(this::setup);
        iEventBus.addListener(this::enqueueIMC);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerMessages(MODID);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"craftingtweaks", (String)"RegisterProvider", () -> {
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.m_128359_("ContainerClass", CraftingStationContainer.class.getName());
            tagCompound.m_128359_("AlignToGrid", "left");
            return tagCompound;
        });
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Configs.Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Configs.Client)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Configs.Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (Configs.Server)specPair2.getLeft();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void block(RegistryEvent.Register<Block> event) {
            RegistryEvents.register(ModBlocks.crafting_station, "crafting_station", event.getRegistry());
            RegistryEvents.register(ModBlocks.crafting_station_slab, "crafting_station_slab", event.getRegistry());
        }

        @SubscribeEvent
        public static void item(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().m_41491_(CreativeModeTab.f_40750_);
            RegistryEvents.register(new BlockItem(ModBlocks.crafting_station, properties), "crafting_station", event.getRegistry());
            RegistryEvents.register(new BlockItem(ModBlocks.crafting_station_slab, properties), "crafting_station_slab", event.getRegistry());
        }

        @SubscribeEvent
        public static void container(RegistryEvent.Register<MenuType<?>> event) {
            RegistryEvents.register(ModMenuTypes.crafting_station, "crafting_station", event.getRegistry());
        }

        @SubscribeEvent
        public static void tile(RegistryEvent.Register<BlockEntityType<?>> event) {
            RegistryEvents.register(ModBlockEntityTypes.crafting_station, "crafting_station", event.getRegistry());
        }

        private static <T extends IForgeRegistryEntry<T>> void register(T obj, String name, IForgeRegistry<T> registry) {
            registry.register((IForgeRegistryEntry)obj.setRegistryName(new ResourceLocation(CraftingStation.MODID, name)));
        }
    }
}

